/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.rich;

import generic.jar.ResourceFile;
import ghidra.app.util.bin.format.pe.rich.MSProductType;
import ghidra.app.util.bin.format.pe.rich.RichProduct;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.xml.NonThreadedXmlPullParserImpl;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class RichProductIdLoader {
    RichProductIdLoader() {
    }

    public static Map<Integer, RichProduct> loadProductIdStore() {
        ArrayList<ResourceFile> fileList = new ArrayList<ResourceFile>();
        try {
            File userFile;
            String userFilePath;
            ResourceFile user;
            ResourceFile builtIn = Application.getModuleDataFile((String)"ms_pe_rich_products.xml");
            if (builtIn != null) {
                fileList.add(builtIn);
            }
            if ((user = new ResourceFile(new File(userFilePath = (userFile = Application.getUserSettingsDirectory().getParentFile()).getAbsolutePath().concat(File.separator).concat("rich_ids.xml")))).exists()) {
                fileList.add(user);
            }
        }
        catch (FileNotFoundException builtIn) {
            // empty catch block
        }
        HashMap<Integer, RichProduct> store = new HashMap<Integer, RichProduct>();
        for (ResourceFile file : fileList) {
            if (!file.exists()) continue;
            try {
                RichProductIdLoader.loadFile(file, store);
            }
            catch (IOException ioe) {
                Msg.error(RichProductIdLoader.class, (Object)("Error loading " + file.getName()), (Throwable)ioe);
            }
        }
        return store;
    }

    private static MSProductType resolveProductType(String toolDescription) {
        String descr = toolDescription.toLowerCase();
        if (descr.contains("import") || toolDescription.equals("IMP")) {
            return MSProductType.Import;
        }
        if (descr.contains("export") || toolDescription.equals("EXP")) {
            return MSProductType.Export;
        }
        if (descr.contains("imp/exp")) {
            return MSProductType.ImportExport;
        }
        if (descr.contains("linker")) {
            return MSProductType.Linker;
        }
        if (toolDescription.contains("link ") || toolDescription.equals("LNK")) {
            return MSProductType.Linker;
        }
        if (descr.contains("masm") || toolDescription.equals("ASM")) {
            return MSProductType.Assembler;
        }
        if (descr.contains("cvtres") || toolDescription.equals("RES")) {
            return MSProductType.CVTRes;
        }
        if (descr.contains("c++ compiler")) {
            return MSProductType.CXX_Compiler;
        }
        if (descr.contains("c compiler")) {
            return MSProductType.C_Compiler;
        }
        if (toolDescription.equals("C++")) {
            return MSProductType.CXX_Compiler;
        }
        if (toolDescription.equals("C")) {
            return MSProductType.C_Compiler;
        }
        return MSProductType.Unknown;
    }

    private static void loadFile(ResourceFile file, Map<Integer, RichProduct> store) throws FileNotFoundException, IOException {
        String fileExtension = FilenameUtils.getExtension((String)file.getAbsolutePath()).toLowerCase();
        if (fileExtension.equals("xml")) {
            try {
                RichProductIdLoader.loadXMLFile(file, store);
            }
            catch (XmlParseException xpe) {
                throw new IOException("Error loading XML file: " + xpe.getMessage(), xpe);
            }
        }
    }

    private static void loadXMLFile(ResourceFile file, Map<Integer, RichProduct> store) throws FileNotFoundException, IOException, XmlParseException {
        InputStream stream = file.getInputStream();
        String name = file.getName();
        RichProductIdLoader.loadXMLFile(name, stream, store);
        stream.close();
    }

    private static void loadXMLFile(String name, InputStream stream, Map<Integer, RichProduct> store) throws IOException, XmlParseException {
        NonThreadedXmlPullParserImpl parser;
        try {
            parser = new NonThreadedXmlPullParserImpl(stream, name, (ErrorHandler)new XMLErrorHandler(), false);
        }
        catch (SAXException e) {
            throw new XmlParseException("Sax Exception", (Throwable)e);
        }
        parser.next();
        try {
            RichProductIdLoader.processProducts((XmlPullParser)parser, store);
        }
        catch (SAXParseException spe) {
            Msg.error(RichProductIdLoader.class, (Object)("Error occurred while parsing XML file " + name), (Throwable)spe);
        }
    }

    private static void processProducts(XmlPullParser parser, Map<Integer, RichProduct> store) throws SAXParseException {
        XmlElement element = parser.next();
        while (!element.isEnd()) {
            String name = element.getName();
            if (name.equals("product")) {
                RichProduct product = RichProductIdLoader.loadRichProduct(element);
                if (product != null) {
                    store.put(product.getCompid().getValue(), product);
                }
            } else {
                throw new SAXParseException("Unexpected element: " + name, null, null, parser.getLineNumber(), parser.getColumnNumber());
            }
            element = parser.next();
            element = parser.next();
        }
    }

    private static RichProduct loadRichProduct(XmlElement element) {
        String prodidStr = element.getAttribute("prodid");
        String tool = element.getAttribute("tool");
        String name = element.getAttribute("name");
        int id = Integer.parseInt(prodidStr, 16);
        MSProductType type = RichProductIdLoader.resolveProductType(tool);
        return new RichProduct(id, name, type);
    }

    private static class XMLErrorHandler
    implements ErrorHandler {
        private XMLErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException("Error: " + exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException("Fatal error: " + exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw new SAXException("Warning: " + exception);
        }
    }
}

