/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.debug.OMFSegDesc;
import java.io.IOException;

public class OMFModule {
    private short ovlNumber;
    private short iLib;
    private short cSeg;
    private short style;
    private OMFSegDesc[] segDescArr;
    private String name;

    static OMFModule createOMFModule(FactoryBundledWithBinaryReader reader, int ptr, int byteCount) throws IOException {
        OMFModule omfModule = (OMFModule)reader.getFactory().create(OMFModule.class, new Object[0]);
        omfModule.initOMFModule(reader, ptr, byteCount);
        return omfModule;
    }

    private void initOMFModule(FactoryBundledWithBinaryReader reader, int ptr, int byteCount) throws IOException {
        int index = ptr;
        this.ovlNumber = reader.readShort(index);
        this.iLib = reader.readShort(index += 2);
        this.cSeg = reader.readShort(index += 2);
        this.style = reader.readShort(index += 2);
        index += 2;
        this.segDescArr = new OMFSegDesc[this.cSeg];
        for (int i = 0; i < this.cSeg; ++i) {
            this.segDescArr[i] = OMFSegDesc.createOMFSegDesc(reader, index);
            index += 12;
        }
        this.name = reader.readAsciiString(++index);
    }

    public short getOvlNumber() {
        return this.ovlNumber;
    }

    public short getILib() {
        return this.iLib;
    }

    public short getStyle() {
        return this.style;
    }

    public String getName() {
        return this.name;
    }

    public OMFSegDesc[] getOMFSegDescs() {
        return this.segDescArr;
    }
}

