/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import java.io.File;
import java.io.IOException;

public class ByteProviderWrapper
implements ByteProvider {
    private ByteProvider provider;
    private long subOffset;
    private long subLength;
    private FSRL fsrl;

    public ByteProviderWrapper(ByteProvider provider, FSRL fsrl) throws IOException {
        this(provider, 0L, provider.length(), fsrl);
    }

    public ByteProviderWrapper(ByteProvider provider, long subOffset, long subLength) {
        this(provider, subOffset, subLength, null);
    }

    public ByteProviderWrapper(ByteProvider provider, long subOffset, long subLength, FSRL fsrl) {
        this.provider = provider;
        this.subOffset = subOffset;
        this.subLength = subLength;
        this.fsrl = fsrl;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public FSRL getFSRL() {
        return this.fsrl;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public String getName() {
        return this.fsrl != null ? this.fsrl.getName() : String.format("%s[0x%x,0x%x]", this.provider.getName(), this.subOffset, this.subLength);
    }

    @Override
    public String getAbsolutePath() {
        return this.fsrl != null ? this.fsrl.getPath() : String.format("%s[0x%x,0x%x]", this.provider.getAbsolutePath(), this.subOffset, this.subLength);
    }

    @Override
    public long length() throws IOException {
        return this.subLength;
    }

    @Override
    public boolean isValidIndex(long index) {
        return 0L <= index && index < this.subLength && this.provider.isValidIndex(this.subOffset + index);
    }

    @Override
    public byte readByte(long index) throws IOException {
        return this.provider.readByte(this.subOffset + index);
    }

    @Override
    public byte[] readBytes(long index, long length) throws IOException {
        return this.provider.readBytes(this.subOffset + index, length);
    }
}

