/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import ghidra.app.nav.LocationMemento;
import ghidra.framework.options.SaveState;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;

public class CodeViewerLocationMemento
extends LocationMemento {
    private final int cursorOffset;

    public CodeViewerLocationMemento(Program program, ProgramLocation location, int cursorOffset) {
        super(program, location);
        this.cursorOffset = cursorOffset;
    }

    public CodeViewerLocationMemento(SaveState saveState, Program[] programs) {
        super(saveState, programs);
        this.cursorOffset = saveState.getInt("CURSOR_OFFSET", 0);
    }

    public int getCursorOffset() {
        return this.cursorOffset;
    }

    @Override
    public void saveState(SaveState saveState) {
        super.saveState(saveState);
        saveState.putInt("CURSOR_OFFSET", this.cursorOffset);
    }
}

