/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.Processor;
import java.io.IOException;

public class LanguageNotFoundException
extends IOException {
    public LanguageNotFoundException(LanguageID languageID, int majorVersion, int minorVersion) {
        super("Language version (V" + majorVersion + "." + minorVersion + " or later) required for '" + languageID + "'");
    }

    public LanguageNotFoundException(LanguageID languageID) {
        super("Language not found for '" + languageID + "'");
    }

    public LanguageNotFoundException(String message) {
        super(message);
    }

    public LanguageNotFoundException(LanguageID languageID, CompilerSpecID compilerSpecID) {
        super("Language/Compiler Spec not found for '" + languageID + "/" + compilerSpecID + "'");
    }

    public LanguageNotFoundException(LanguageID languageID, String msg) {
        super("Language not found for '" + languageID + "' " + msg);
    }

    public LanguageNotFoundException(Processor processor) {
        super("Language not found for processor: " + processor.toString());
    }
}

