/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.IteratorSTL;
import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.context.Token;
import ghidra.pcodeCPort.slghpattern.ContextPattern;
import ghidra.pcodeCPort.slghpattern.InstructionPattern;
import ghidra.pcodeCPort.slghpattern.Pattern;
import ghidra.pcodeCPort.slghpattern.PatternBlock;
import ghidra.sleigh.grammar.Location;

public class TokenPattern {
    public final Location location;
    private Pattern pattern;
    private VectorSTL<Token> toklist = new VectorSTL();
    private boolean leftell;
    private boolean rightell;
    private static int calls = 0;

    private TokenPattern(Location location, Pattern pat) {
        this.location = location;
        this.pattern = pat;
        this.setLeftEllipsis(false);
        this.setRightEllipsis(false);
    }

    public void dispose() {
        this.pattern.dispose();
    }

    public void setLeftEllipsis(boolean val) {
        this.leftell = val;
    }

    public void setRightEllipsis(boolean val) {
        this.rightell = val;
    }

    public boolean getLeftEllipsis() {
        return this.leftell;
    }

    public boolean getRightEllipsis() {
        return this.rightell;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean alwaysTrue() {
        return this.pattern.alwaysTrue();
    }

    public boolean alwaysFalse() {
        return this.pattern.alwaysFalse();
    }

    public boolean alwaysInstructionTrue() {
        return this.pattern.alwaysInstructionTrue();
    }

    private int resolveTokens(TokenPattern tok1, TokenPattern tok2) {
        int minsize;
        ++calls;
        boolean reversedirection = false;
        this.setLeftEllipsis(false);
        this.setRightEllipsis(false);
        int ressa = 0;
        int n = minsize = tok1.toklist.size() < tok2.toklist.size() ? tok1.toklist.size() : tok2.toklist.size();
        if (minsize == 0) {
            if (tok1.toklist.size() == 0 && !tok1.getLeftEllipsis() && !tok1.getRightEllipsis()) {
                this.toklist = tok2.toklist.copy();
                this.setLeftEllipsis(tok2.getLeftEllipsis());
                this.setRightEllipsis(tok2.getRightEllipsis());
                return 0;
            }
            if (tok2.toklist.size() == 0 && !tok2.getLeftEllipsis() && !tok2.getRightEllipsis()) {
                this.toklist = tok1.toklist.copy();
                this.setLeftEllipsis(tok1.getLeftEllipsis());
                this.setRightEllipsis(tok1.getRightEllipsis());
                return 0;
            }
        }
        if (tok1.getLeftEllipsis()) {
            reversedirection = true;
            if (tok2.getRightEllipsis()) {
                throw new SleighError("Right/left ellipsis", this.location);
            }
            if (tok2.getLeftEllipsis()) {
                this.setLeftEllipsis(true);
            } else {
                if (tok1.toklist.size() != minsize) {
                    throw new SleighError(String.format("Mismatched pattern sizes -- %d vs %d", tok1.toklist.size(), minsize), this.location);
                }
                if (tok1.toklist.size() == tok2.toklist.size()) {
                    throw new SleighError("Pattern size cannot vary (missing ... ?)", this.location);
                }
            }
        } else if (tok1.getRightEllipsis()) {
            if (tok2.getLeftEllipsis()) {
                throw new SleighError("Left/right ellipsis", this.location);
            }
            if (tok2.getRightEllipsis()) {
                this.setRightEllipsis(true);
            } else {
                if (tok1.toklist.size() != minsize) {
                    throw new SleighError(String.format("Mismatched pattern sizes -- %d vs %d", tok1.toklist.size(), minsize), this.location);
                }
                if (tok1.toklist.size() == tok2.toklist.size()) {
                    throw new SleighError("Pattern size cannot vary (missing ... ?)", this.location);
                }
            }
        } else if (tok2.getLeftEllipsis()) {
            reversedirection = true;
            if (tok2.toklist.size() != minsize) {
                throw new SleighError(String.format("Mismatched pattern sizes -- %d vs %d", tok2.toklist.size(), minsize), this.location);
            }
            if (tok1.toklist.size() == tok2.toklist.size()) {
                throw new SleighError("Pattern size cannot vary (missing ... ?)", this.location);
            }
        } else if (tok2.getRightEllipsis()) {
            if (tok2.toklist.size() != minsize) {
                throw new SleighError(String.format("Mismatched pattern sizes -- %d vs %d", tok1.toklist.size(), minsize), this.location);
            }
            if (tok1.toklist.size() == tok2.toklist.size()) {
                throw new SleighError("Pattern size cannot vary (missing ... ?)", this.location);
            }
        } else if (tok2.toklist.size() != tok1.toklist.size()) {
            throw new SleighError(String.format("Mismatched pattern sizes -- %d vs %d", tok2.toklist.size(), tok1.toklist.size()), this.location);
        }
        if (reversedirection) {
            int i;
            for (i = 0; i < minsize; ++i) {
                if (tok1.toklist.get(tok1.toklist.size() - 1 - i) == tok2.toklist.get(tok2.toklist.size() - 1 - i)) continue;
                throw new SleighError("Mismatched tokens when combining patterns", this.location);
            }
            if (tok1.toklist.size() <= tok2.toklist.size()) {
                for (i = minsize; i < tok2.toklist.size(); ++i) {
                    ressa += ((Token)tok2.toklist.get(tok2.toklist.size() - 1 - i)).getSize();
                }
            } else {
                for (i = minsize; i < tok1.toklist.size(); ++i) {
                    ressa += ((Token)tok1.toklist.get(tok1.toklist.size() - 1 - i)).getSize();
                }
            }
            if (tok1.toklist.size() < tok2.toklist.size()) {
                ressa = -ressa;
            }
        } else {
            for (int i = 0; i < minsize; ++i) {
                if (((Token)tok1.toklist.get(i)).equals(tok2.toklist.get(i))) continue;
                throw new SleighError("Mismatched tokens when combining patterns", this.location);
            }
        }
        this.toklist = tok1.toklist.size() <= tok2.toklist.size() ? tok2.toklist.copy() : tok1.toklist.copy();
        return ressa;
    }

    private static PatternBlock buildSingle(int startbit, int endbit, int byteval) {
        int offset = 0;
        int size = endbit - startbit + 1;
        while (startbit >= 8) {
            ++offset;
            startbit -= 8;
            endbit -= 8;
        }
        int mask = -1 << 32 - size;
        byteval = byteval << 32 - size & mask;
        return new PatternBlock(offset, mask >>>= startbit, byteval >>>= startbit);
    }

    private static PatternBlock buildBigBlock(int size, int bitstart, int bitend, long value) {
        int startbit = 8 * size - 1 - bitend;
        int endbit = 8 * size - 1 - bitstart;
        PatternBlock block = null;
        while (endbit >= startbit) {
            int tmpstart = endbit - (endbit & 7);
            if (tmpstart < startbit) {
                tmpstart = startbit;
            }
            PatternBlock tmpblock = TokenPattern.buildSingle(tmpstart, endbit, (int)value);
            if (block == null) {
                block = tmpblock;
            } else {
                PatternBlock newblock = block.intersect(tmpblock);
                block.dispose();
                tmpblock.dispose();
                block = newblock;
            }
            value >>>= endbit - tmpstart + 1;
            endbit = tmpstart - 1;
        }
        return block;
    }

    public static PatternBlock buildLittleBlock(int size, int bitstart, int bitend, long value) {
        PatternBlock block = null;
        int startbit = bitstart / 8 * 8;
        int endbit = bitend / 8 * 8;
        bitend %= 8;
        bitstart %= 8;
        if (startbit == endbit) {
            block = TokenPattern.buildSingle(startbit += 7 - bitend, endbit += 7 - bitstart, (int)value);
        } else {
            PatternBlock newblock;
            PatternBlock tmpblock;
            block = TokenPattern.buildSingle(startbit, startbit + (7 - bitstart), (int)value);
            value >>>= 8 - bitstart;
            startbit += 8;
            while (startbit < endbit) {
                tmpblock = TokenPattern.buildSingle(startbit, startbit + 7, (int)value);
                if (block == null) {
                    block = tmpblock;
                } else {
                    newblock = block.intersect(tmpblock);
                    block.dispose();
                    tmpblock.dispose();
                    block = newblock;
                }
                value >>>= 8;
                startbit += 8;
            }
            tmpblock = TokenPattern.buildSingle(endbit + (7 - bitend), endbit + 7, (int)value);
            if (block == null) {
                block = tmpblock;
            } else {
                newblock = block.intersect(tmpblock);
                block.dispose();
                tmpblock.dispose();
                block = newblock;
            }
        }
        return block;
    }

    public TokenPattern(Location location) {
        this.location = location;
        this.setLeftEllipsis(false);
        this.setRightEllipsis(false);
        this.pattern = new InstructionPattern(true);
    }

    public TokenPattern(Location location, boolean tf) {
        this.location = location;
        this.setLeftEllipsis(false);
        this.setRightEllipsis(false);
        this.pattern = new InstructionPattern(tf);
    }

    TokenPattern(Location location, Token tok) {
        this.location = location;
        this.setLeftEllipsis(false);
        this.setRightEllipsis(false);
        this.pattern = new InstructionPattern(true);
        this.toklist.push_back((Object)tok);
    }

    public TokenPattern(Location location, Token tok, long value, int bitstart, int bitend) {
        this.location = location;
        this.toklist.push_back((Object)tok);
        this.setLeftEllipsis(false);
        this.setRightEllipsis(false);
        PatternBlock block = tok.isBigEndian() ? TokenPattern.buildBigBlock(tok.getSize(), bitstart, bitend, value) : TokenPattern.buildLittleBlock(tok.getSize(), bitstart, bitend, value);
        this.pattern = new InstructionPattern(block);
    }

    public TokenPattern(Location location, long value, int startbit, int endbit) {
        this.location = location;
        this.setLeftEllipsis(false);
        this.setRightEllipsis(false);
        int size = endbit / 8 + 1;
        PatternBlock block = TokenPattern.buildBigBlock(size, size * 8 - 1 - endbit, size * 8 - 1 - startbit, value);
        this.pattern = new ContextPattern(block);
    }

    public TokenPattern(Location location, TokenPattern tokpat) {
        this.location = location;
        this.simplifyPattern(tokpat);
        this.toklist = new VectorSTL(tokpat.toklist);
        this.setLeftEllipsis(tokpat.getLeftEllipsis());
        this.setRightEllipsis(tokpat.getRightEllipsis());
    }

    public TokenPattern copyInto(TokenPattern tokpat) {
        this.pattern.dispose();
        this.simplifyPattern(tokpat);
        this.toklist = new VectorSTL(tokpat.toklist);
        this.setLeftEllipsis(tokpat.getLeftEllipsis());
        this.setRightEllipsis(tokpat.getRightEllipsis());
        return this;
    }

    private void simplifyPattern(TokenPattern tokpat) {
        this.pattern = tokpat.pattern.simplifyClone();
    }

    public void simplifyPattern() {
        this.simplifyPattern(this);
    }

    public TokenPattern doAnd(TokenPattern tokpat) {
        TokenPattern res = new TokenPattern(this.location, (Pattern)null);
        int sa = res.resolveTokens(this, tokpat);
        res.pattern = this.pattern.doAnd(tokpat.pattern, sa);
        return res;
    }

    public TokenPattern doOr(TokenPattern tokpat) {
        TokenPattern res = new TokenPattern(this.location, (Pattern)null);
        int sa = res.resolveTokens(this, tokpat);
        res.pattern = this.pattern.doOr(tokpat.pattern, sa);
        return res;
    }

    public TokenPattern doCat(TokenPattern tokpat) {
        int sa;
        TokenPattern res = new TokenPattern(this.location, (Pattern)null);
        res.setLeftEllipsis(this.getLeftEllipsis());
        res.setRightEllipsis(this.getRightEllipsis());
        res.toklist = this.toklist.copy();
        if (this.getRightEllipsis() || tokpat.getLeftEllipsis()) {
            if (this.getRightEllipsis() && !tokpat.alwaysInstructionTrue()) {
                throw new SleighError("Interior ellipsis in pattern", this.location);
            }
            if (tokpat.getLeftEllipsis()) {
                if (!this.alwaysInstructionTrue()) {
                    throw new SleighError("Interior ellipsis in pattern", this.location);
                }
                res.setLeftEllipsis(true);
            }
            sa = -1;
        } else {
            sa = 0;
            IteratorSTL iter = this.toklist.begin();
            while (!iter.isEnd()) {
                sa += ((Token)iter.get()).getSize();
                iter.increment();
            }
            iter = tokpat.toklist.begin();
            while (!iter.isEnd()) {
                res.toklist.push_back((Object)((Token)iter.get()));
                iter.increment();
            }
            res.setRightEllipsis(tokpat.getRightEllipsis());
        }
        if (res.getRightEllipsis() && res.getLeftEllipsis()) {
            throw new SleighError("Double ellipsis in pattern", this.location);
        }
        res.pattern = sa < 0 ? this.pattern.doAnd(tokpat.pattern, 0) : this.pattern.doAnd(tokpat.pattern, sa);
        return res;
    }

    public TokenPattern commonSubPattern(TokenPattern tokpat) {
        TokenPattern patres = new TokenPattern(this.location, (Pattern)null);
        boolean reversedirection = false;
        if (this.getLeftEllipsis() || tokpat.getLeftEllipsis()) {
            if (this.getRightEllipsis() || tokpat.getRightEllipsis()) {
                throw new SleighError("Right/left ellipsis in commonSubPattern", this.location);
            }
            reversedirection = true;
        }
        patres.setLeftEllipsis(this.getLeftEllipsis() || tokpat.getLeftEllipsis());
        patres.setRightEllipsis(this.getRightEllipsis() || tokpat.getRightEllipsis());
        int minnum = this.toklist.size();
        int maxnum = tokpat.toklist.size();
        if (maxnum < minnum) {
            int tmp = minnum;
            minnum = maxnum;
            maxnum = tmp;
        }
        if (reversedirection) {
            Token tok;
            int i;
            for (i = 0; i < minnum && (tok = (Token)this.toklist.get(this.toklist.size() - 1 - i)).equals(tokpat.toklist.get(tokpat.toklist.size() - 1 - i)); ++i) {
                patres.toklist.insert(patres.toklist.begin(), (Object)tok);
            }
            if (i < maxnum) {
                patres.setLeftEllipsis(true);
            }
        } else {
            Token tok;
            int i;
            for (i = 0; i < minnum && (tok = (Token)this.toklist.get(i)).equals(tokpat.toklist.get(i)); ++i) {
                patres.toklist.push_back((Object)tok);
            }
            if (i < maxnum) {
                patres.setRightEllipsis(true);
            }
        }
        patres.pattern = this.pattern.commonSubPattern(tokpat.pattern, 0);
        return patres;
    }

    public int getMinimumLength() {
        int length = 0;
        for (int i = 0; i < this.toklist.size(); ++i) {
            length += ((Token)this.toklist.get(i)).getSize();
        }
        return length;
    }
}

