/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.transport;

import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.DHGexParameters;
import ch.ethz.ssh2.crypto.CryptoWishList;
import ch.ethz.ssh2.crypto.KeyMaterial;
import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import ch.ethz.ssh2.crypto.cipher.BlockCipherFactory;
import ch.ethz.ssh2.crypto.digest.MAC;
import ch.ethz.ssh2.log.Logger;
import ch.ethz.ssh2.packets.PacketKexInit;
import ch.ethz.ssh2.packets.PacketNewKeys;
import ch.ethz.ssh2.signature.DSAPrivateKey;
import ch.ethz.ssh2.signature.RSAPrivateKey;
import ch.ethz.ssh2.transport.ClientServerHello;
import ch.ethz.ssh2.transport.KexParameters;
import ch.ethz.ssh2.transport.KexState;
import ch.ethz.ssh2.transport.MessageHandler;
import ch.ethz.ssh2.transport.NegotiateException;
import ch.ethz.ssh2.transport.NegotiatedParameters;
import ch.ethz.ssh2.transport.TransportManager;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.SecureRandom;

public abstract class KexManager
implements MessageHandler {
    protected static final Logger log = Logger.getLogger(KexManager.class);
    KexState kxs;
    int kexCount = 0;
    KeyMaterial km;
    byte[] sessionId;
    ClientServerHello csh;
    final Object accessLock = new Object();
    ConnectionInfo lastConnInfo = null;
    boolean connectionClosed = false;
    boolean ignore_next_kex_packet = false;
    final TransportManager tm;
    CryptoWishList nextKEXcryptoWishList;
    DHGexParameters nextKEXdhgexParameters;
    DSAPrivateKey nextKEXdsakey;
    RSAPrivateKey nextKEXrsakey;
    final SecureRandom rnd;

    public KexManager(TransportManager tm, ClientServerHello csh, CryptoWishList initialCwl, SecureRandom rnd) {
        this.tm = tm;
        this.csh = csh;
        this.nextKEXcryptoWishList = initialCwl;
        this.nextKEXdhgexParameters = new DHGexParameters();
        this.rnd = rnd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConnectionInfo getOrWaitForConnectionInfo(int minKexCount) throws IOException {
        Object object = this.accessLock;
        synchronized (object) {
            while (this.lastConnInfo == null || this.lastConnInfo.keyExchangeCounter < minKexCount) {
                if (this.connectionClosed) {
                    throw new IOException("Key exchange was not finished, connection is closed.", this.tm.getReasonClosedCause());
                }
                try {
                    this.accessLock.wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException(e.getMessage());
                }
            }
            return this.lastConnInfo;
        }
    }

    private String getFirstMatch(String[] client, String[] server) throws NegotiateException {
        if (client == null || server == null) {
            throw new IllegalArgumentException();
        }
        if (client.length == 0) {
            return null;
        }
        for (int i = 0; i < client.length; ++i) {
            for (int j = 0; j < server.length; ++j) {
                if (!client[i].equals(server[j])) continue;
                return client[i];
            }
        }
        throw new NegotiateException();
    }

    private boolean compareFirstOfNameList(String[] a, String[] b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException();
        }
        if (a.length == 0 && b.length == 0) {
            return true;
        }
        if (a.length == 0 || b.length == 0) {
            return false;
        }
        return a[0].equals(b[0]);
    }

    private boolean isGuessOK(KexParameters cpar, KexParameters spar) {
        if (cpar == null || spar == null) {
            throw new IllegalArgumentException();
        }
        if (!this.compareFirstOfNameList(cpar.kex_algorithms, spar.kex_algorithms)) {
            return false;
        }
        return this.compareFirstOfNameList(cpar.server_host_key_algorithms, spar.server_host_key_algorithms);
    }

    protected NegotiatedParameters mergeKexParameters(KexParameters client, KexParameters server) {
        NegotiatedParameters np = new NegotiatedParameters();
        try {
            np.kex_algo = this.getFirstMatch(client.kex_algorithms, server.kex_algorithms);
            log.info("kex_algo=" + np.kex_algo);
            np.server_host_key_algo = this.getFirstMatch(client.server_host_key_algorithms, server.server_host_key_algorithms);
            log.info("server_host_key_algo=" + np.server_host_key_algo);
            np.enc_algo_client_to_server = this.getFirstMatch(client.encryption_algorithms_client_to_server, server.encryption_algorithms_client_to_server);
            np.enc_algo_server_to_client = this.getFirstMatch(client.encryption_algorithms_server_to_client, server.encryption_algorithms_server_to_client);
            log.info("enc_algo_client_to_server=" + np.enc_algo_client_to_server);
            log.info("enc_algo_server_to_client=" + np.enc_algo_server_to_client);
            np.mac_algo_client_to_server = this.getFirstMatch(client.mac_algorithms_client_to_server, server.mac_algorithms_client_to_server);
            np.mac_algo_server_to_client = this.getFirstMatch(client.mac_algorithms_server_to_client, server.mac_algorithms_server_to_client);
            log.info("mac_algo_client_to_server=" + np.mac_algo_client_to_server);
            log.info("mac_algo_server_to_client=" + np.mac_algo_server_to_client);
            np.comp_algo_client_to_server = this.getFirstMatch(client.compression_algorithms_client_to_server, server.compression_algorithms_client_to_server);
            np.comp_algo_server_to_client = this.getFirstMatch(client.compression_algorithms_server_to_client, server.compression_algorithms_server_to_client);
            log.info("comp_algo_client_to_server=" + np.comp_algo_client_to_server);
            log.info("comp_algo_server_to_client=" + np.comp_algo_server_to_client);
        }
        catch (NegotiateException e) {
            return null;
        }
        try {
            np.lang_client_to_server = this.getFirstMatch(client.languages_client_to_server, server.languages_client_to_server);
        }
        catch (NegotiateException e1) {
            np.lang_client_to_server = null;
        }
        try {
            np.lang_server_to_client = this.getFirstMatch(client.languages_server_to_client, server.languages_server_to_client);
        }
        catch (NegotiateException e2) {
            np.lang_server_to_client = null;
        }
        if (this.isGuessOK(client, server)) {
            np.guessOK = true;
        }
        return np;
    }

    public synchronized void initiateKEX(CryptoWishList cwl, DHGexParameters dhgex, DSAPrivateKey dsa, RSAPrivateKey rsa) throws IOException {
        this.nextKEXcryptoWishList = cwl;
        this.nextKEXdhgexParameters = dhgex;
        this.nextKEXdsakey = dsa;
        this.nextKEXrsakey = rsa;
        if (this.kxs == null) {
            this.kxs = new KexState();
            this.kxs.local_dsa_key = dsa;
            this.kxs.local_rsa_key = rsa;
            this.kxs.dhgexParameters = this.nextKEXdhgexParameters;
            this.kxs.localKEX = new PacketKexInit(this.nextKEXcryptoWishList, this.rnd);
            this.tm.sendKexMessage(this.kxs.localKEX.getPayload());
        }
    }

    private boolean establishKeyMaterial() {
        try {
            int mac_cs_key_len = MAC.getKeyLen(this.kxs.np.mac_algo_client_to_server);
            int enc_cs_key_len = BlockCipherFactory.getKeySize(this.kxs.np.enc_algo_client_to_server);
            int enc_cs_block_len = BlockCipherFactory.getBlockSize(this.kxs.np.enc_algo_client_to_server);
            int mac_sc_key_len = MAC.getKeyLen(this.kxs.np.mac_algo_server_to_client);
            int enc_sc_key_len = BlockCipherFactory.getKeySize(this.kxs.np.enc_algo_server_to_client);
            int enc_sc_block_len = BlockCipherFactory.getBlockSize(this.kxs.np.enc_algo_server_to_client);
            this.km = KeyMaterial.create("SHA1", this.kxs.H, this.kxs.K, this.sessionId, enc_cs_key_len, enc_cs_block_len, mac_cs_key_len, enc_sc_key_len, enc_sc_block_len, mac_sc_key_len);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    protected void finishKex(boolean clientMode) throws IOException {
        MAC mac;
        BlockCipher cbc;
        if (this.sessionId == null) {
            this.sessionId = this.kxs.H;
        }
        this.establishKeyMaterial();
        PacketNewKeys ign = new PacketNewKeys();
        this.tm.sendKexMessage(ign.getPayload());
        try {
            cbc = BlockCipherFactory.createCipher(clientMode ? this.kxs.np.enc_algo_client_to_server : this.kxs.np.enc_algo_server_to_client, true, clientMode ? this.km.enc_key_client_to_server : this.km.enc_key_server_to_client, clientMode ? this.km.initial_iv_client_to_server : this.km.initial_iv_server_to_client);
            mac = new MAC(clientMode ? this.kxs.np.mac_algo_client_to_server : this.kxs.np.mac_algo_server_to_client, clientMode ? this.km.integrity_key_client_to_server : this.km.integrity_key_server_to_client);
        }
        catch (IllegalArgumentException e1) {
            throw new IOException("Fatal error during MAC startup!");
        }
        this.tm.changeSendCipher(cbc, mac);
        this.tm.kexFinished();
    }

    public static final String[] getDefaultServerHostkeyAlgorithmList() {
        return new String[]{"ssh-rsa", "ssh-dss"};
    }

    public static final void checkServerHostkeyAlgorithmsList(String[] algos) {
        for (int i = 0; i < algos.length; ++i) {
            if ("ssh-rsa".equals(algos[i]) || "ssh-dss".equals(algos[i])) continue;
            throw new IllegalArgumentException("Unknown server host key algorithm '" + algos[i] + "'");
        }
    }

    public static final String[] getDefaultClientKexAlgorithmList() {
        return new String[]{"diffie-hellman-group-exchange-sha1", "diffie-hellman-group14-sha1", "diffie-hellman-group1-sha1"};
    }

    public static final String[] getDefaultServerKexAlgorithmList() {
        return new String[]{"diffie-hellman-group14-sha1", "diffie-hellman-group1-sha1"};
    }

    public static final void checkKexAlgorithmList(String[] algos) {
        for (int i = 0; i < algos.length; ++i) {
            if ("diffie-hellman-group-exchange-sha1".equals(algos[i]) || "diffie-hellman-group14-sha1".equals(algos[i]) || "diffie-hellman-group1-sha1".equals(algos[i])) continue;
            throw new IllegalArgumentException("Unknown kex algorithm '" + algos[i] + "'");
        }
    }
}

