/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver.ui;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import utilities.util.FileUtilities;

class WellKnownSymbolServerLocation {
    private String locationCategory;
    private String location;
    private String warning;
    private String fileOrigin;

    WellKnownSymbolServerLocation(String location, String locationCategory, String warning, String fileOrigin) {
        this.location = location;
        this.locationCategory = locationCategory;
        this.warning = warning;
        this.fileOrigin = fileOrigin;
    }

    String getLocationCategory() {
        return this.locationCategory;
    }

    String getLocation() {
        return this.location;
    }

    String getWarning() {
        return this.warning;
    }

    String getFileOrigin() {
        return this.fileOrigin;
    }

    public int hashCode() {
        return Objects.hash(this.location, this.locationCategory, this.warning);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WellKnownSymbolServerLocation other = (WellKnownSymbolServerLocation)obj;
        return Objects.equals(this.location, other.location) && Objects.equals(this.locationCategory, other.locationCategory) && Objects.equals(this.warning, other.warning);
    }

    public static List<WellKnownSymbolServerLocation> loadAll() {
        List pdbUrlFiles = Application.findFilesByExtensionInApplication((String)".pdburl");
        ArrayList<WellKnownSymbolServerLocation> results = new ArrayList<WellKnownSymbolServerLocation>();
        for (ResourceFile file : pdbUrlFiles) {
            try {
                List lines = FileUtilities.getLines((ResourceFile)file);
                for (String line : lines) {
                    String[] fields = line.split("\\|");
                    if (fields.length <= 1) continue;
                    results.add(new WellKnownSymbolServerLocation(fields[1], fields[0], fields.length > 2 ? fields[2] : null, file.getName()));
                }
            }
            catch (IOException e) {
                Msg.warn(WellKnownSymbolServerLocation.class, (Object)("Unable to read pdburl file: " + file));
            }
        }
        return results;
    }
}

