/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RegisterName;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractDefinedSingleAddressRangeMsSymbol;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRegisterDimensionalityDARMsSymbol
extends AbstractDefinedSingleAddressRangeMsSymbol {
    protected int registerType;
    protected RegisterName registerName;
    protected int registerIndices;
    protected boolean isSpilledUserDefinedTypeMember;
    protected MemorySpace memorySpace;
    protected int offsetInParent;
    protected int sizeInParent;
    protected int[] multidimensionalOffsetOfVariableLocationInRegister;

    public AbstractRegisterDimensionalityDARMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.registerType = reader.parseUnsignedShortVal();
        this.registerName = new RegisterName(pdb, this.registerType);
        int fields = reader.parseUnsignedShortVal();
        this.registerIndices = fields & 3;
        this.isSpilledUserDefinedTypeMember = ((fields >>= 2) & 1) == 1;
        this.memorySpace = MemorySpace.fromValue((fields >>= 1) & 0xF);
        this.offsetInParent = reader.parseUnsignedShortVal();
        this.sizeInParent = reader.parseUnsignedShortVal();
        int numRangeAndGapsBytes = reader.getLimit() - 10 - this.registerIndices * 4;
        PdbByteReader rangeAndGapsReader = reader.getSubPdbByteReader(numRangeAndGapsBytes);
        super.parseRangeAndGaps(rangeAndGapsReader);
        this.multidimensionalOffsetOfVariableLocationInRegister = new int[this.registerIndices];
        for (int i = 0; i < this.registerIndices; ++i) {
            this.multidimensionalOffsetOfVariableLocationInRegister[i] = reader.parseInt();
        }
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(this.getSymbolTypeName());
        builder.append(String.format(": %s, RegisterIndices = %d, ", this.registerName.toString(), this.registerIndices));
        builder.append((Object)this.memorySpace);
        this.emitRangeAndGaps(builder);
        for (int i = 0; i < this.registerIndices; ++i) {
            builder.append(String.format(" %d", this.multidimensionalOffsetOfVariableLocationInRegister[i]));
        }
    }

    public static enum MemorySpace {
        INVALID("INVALID MEMORY SPACE", -1),
        DATA("DATA", 0),
        SAMPLER("SAMPLER", 1),
        RESOURCE("RESOURCE", 2),
        READWRITERESOURCE("RWRESOURCE", 3);

        private static final Map<Integer, MemorySpace> BY_VALUE;
        public final String label;
        public final int value;

        public String toString() {
            return this.label;
        }

        public static MemorySpace fromValue(int val) {
            return BY_VALUE.getOrDefault(val, INVALID);
        }

        private MemorySpace(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, MemorySpace>();
            for (MemorySpace val : MemorySpace.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

