/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractSectionContribution;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;

public class SectionContribution600
extends AbstractSectionContribution {
    @Override
    void deserialize(PdbByteReader reader) throws PdbException {
        this.isect = reader.parseUnsignedShortVal();
        reader.parseBytes(2);
        this.offset = reader.parseInt();
        this.length = reader.parseInt();
        this.characteristics = reader.parseUnsignedIntVal();
        this.imod = reader.parseUnsignedShortVal();
        reader.align4();
        this.dataCrc = reader.parseUnsignedIntVal();
        this.relocationCrc = reader.parseUnsignedIntVal();
    }

    @Override
    String dumpInternals() {
        StringBuilder builder = new StringBuilder();
        builder.append("isect: ");
        builder.append(this.isect);
        builder.append("\noffset: ");
        builder.append(this.offset);
        builder.append("\nlength: ");
        builder.append(this.length);
        builder.append(String.format("\ncharacteristics: 0X%08X", this.characteristics));
        builder.append("\nimod: ");
        builder.append(this.imod);
        builder.append("\ndataCrc: ");
        builder.append(this.dataCrc);
        builder.append("\nrelocationCrc: ");
        builder.append(this.relocationCrc);
        return builder.toString();
    }
}

