/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.StatedTransformer;
import com.googlecode.dex2jar.ir.ts.UniqueQueue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AggTransformer
extends StatedTransformer {
    private static MergeResult FAIL = new MergeResult();
    private static MergeResult SUCCESS = new MergeResult();

    @Override
    public boolean transformReportChanged(IrMethod method) {
        boolean changed = false;
        HashSet<Stmt> locationSensitiveStmts = new HashSet<Stmt>();
        changed = this.simpleMergeLocals(method, changed, locationSensitiveStmts);
        if (locationSensitiveStmts.size() == 0) {
            return changed;
        }
        ReplaceX replaceX = new ReplaceX();
        UniqueQueue q = new UniqueQueue();
        q.addAll(locationSensitiveStmts);
        block5: while (!q.isEmpty()) {
            Stmt stmt = (Stmt)q.poll();
            Local local = (Local)stmt.getOp1();
            Stmt next = stmt.getNext();
            switch (next.st) {
                case IDENTITY: 
                case LABEL: 
                case NOP: 
                case FILL_ARRAY_DATA: 
                case RETURN_VOID: 
                case GOTO: {
                    break;
                }
                default: {
                    try {
                        AggTransformer.localCanExecFirst(local, next);
                        throw new RuntimeException();
                    }
                    catch (MergeResult e) {
                        if (e != SUCCESS) continue block5;
                        replaceX.local = local;
                        replaceX.replaceWith = stmt.getOp2();
                        method.locals.remove(local);
                        method.stmts.remove(stmt);
                        Cfg.travelMod(next, (Cfg.TravelCallBack)replaceX, false);
                        Stmt pre = next.getPre();
                        if (pre == null || !locationSensitiveStmts.contains(pre)) continue block5;
                        q.add(pre);
                    }
                }
            }
        }
        return changed;
    }

    private static void localCanExecFirst(Local local, Stmt target) throws MergeResult {
        block0 : switch (target.et) {
            case E0: 
            case En: {
                throw FAIL;
            }
            case E1: {
                AggTransformer.localCanExecFirst(local, target.getOp());
                break;
            }
            case E2: {
                AssignStmt as = (AssignStmt)target;
                Value op1 = as.getOp1();
                Value op2 = as.getOp2();
                switch (op1.vt) {
                    case LOCAL: {
                        AggTransformer.localCanExecFirst(local, op2);
                        break block0;
                    }
                    case FIELD: {
                        AggTransformer.localCanExecFirst(local, op1.getOp());
                    }
                    case STATIC_FIELD: {
                        AggTransformer.localCanExecFirst(local, op2);
                        break block0;
                    }
                    case ARRAY: {
                        AggTransformer.localCanExecFirst(local, op1.getOp1());
                        AggTransformer.localCanExecFirst(local, op1.getOp2());
                        AggTransformer.localCanExecFirst(local, op2);
                    }
                }
            }
        }
        throw FAIL;
    }

    private static void localCanExecFirst(Local local, Value op) throws MergeResult {
        switch (op.et) {
            case E0: {
                if (local.vt != Value.VT.LOCAL || op != local) break;
                throw SUCCESS;
            }
            case E1: {
                AggTransformer.localCanExecFirst(local, op.getOp());
                break;
            }
            case E2: {
                AggTransformer.localCanExecFirst(local, op.getOp1());
                AggTransformer.localCanExecFirst(local, op.getOp2());
                break;
            }
            case En: {
                Value[] valueArray = op.getOps();
                int n = valueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Value v = valueArray[n2];
                    AggTransformer.localCanExecFirst(local, v);
                    ++n2;
                }
                break;
            }
        }
        boolean shouldExclude = false;
        if (op.vt == Value.VT.INVOKE_STATIC) {
            InvokeExpr ie = (InvokeExpr)op;
            if (ie.name.equals("valueOf") && ie.owner.startsWith("Ljava/lang/") && ie.args.length == 1 && ie.args[0].length() == 1) {
                shouldExclude = true;
            }
        }
        if (!AggTransformer.isLocationInsensitive(op.vt) && !shouldExclude) {
            throw FAIL;
        }
    }

    private boolean simpleMergeLocals(IrMethod method, boolean changed, Set<Stmt> locationSensitiveStmts) {
        if (method.locals.size() == 0) {
            return false;
        }
        int[] readCounts = Cfg.countLocalReads(method);
        Set<Local> useInPhi = this.collectLocalUsedInPhi(method);
        final HashMap<Local, Value> toReplace = new HashMap<Local, Value>();
        Iterator<Stmt> it = method.stmts.iterator();
        while (it.hasNext()) {
            Local local;
            Stmt p = it.next();
            if (p.st != Stmt.ST.ASSIGN || p.getOp1().vt != Value.VT.LOCAL || useInPhi.contains(local = (Local)p.getOp1()) || readCounts[local._ls_index] >= 2) continue;
            Value op2 = p.getOp2();
            if (AggTransformer.isLocationInsensitive(op2)) {
                method.locals.remove(local);
                toReplace.put(local, op2);
                it.remove();
                changed = true;
                continue;
            }
            locationSensitiveStmts.add(p);
        }
        Cfg.TravelCallBack tcb = new Cfg.TravelCallBack(){

            @Override
            public Value onAssign(Local v, AssignStmt as) {
                return v;
            }

            @Override
            public Value onUse(Local v) {
                Value v2 = (Value)toReplace.get(v);
                if (v2 != null) {
                    return v2;
                }
                return v;
            }
        };
        this.modReplace(toReplace, tcb);
        Cfg.travelMod(method.stmts, tcb, false);
        return changed;
    }

    private Set<Local> collectLocalUsedInPhi(IrMethod method) {
        HashSet<Local> useInPhi = new HashSet<Local>();
        if (method.phiLabels != null) {
            for (LabelStmt labelStmt : method.phiLabels) {
                if (labelStmt.phis == null) continue;
                for (AssignStmt phi : labelStmt.phis) {
                    useInPhi.add((Local)phi.getOp1());
                    Value[] valueArray = phi.getOp2().getOps();
                    int n = valueArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Value op = valueArray[n2];
                        useInPhi.add((Local)op);
                        ++n2;
                    }
                }
            }
        }
        return useInPhi;
    }

    private void modReplace(Map<Local, Value> toReplace, Cfg.TravelCallBack tcb) {
        for (Map.Entry<Local, Value> e : toReplace.entrySet()) {
            Value v = e.getValue();
            if (v.vt == Value.VT.LOCAL) {
                Value v2;
                while ((v2 = toReplace.get(v)) != null) {
                    v = v2;
                    if (v.vt == Value.VT.LOCAL) continue;
                }
                e.setValue(v);
                continue;
            }
            Cfg.travelMod(v, tcb);
        }
    }

    static boolean isLocationInsensitive(Value.VT vt) {
        switch (vt) {
            case ADD: 
            case AND: 
            case CONSTANT: 
            case DCMPG: 
            case DCMPL: 
            case EQ: 
            case FCMPG: 
            case FCMPL: 
            case GE: 
            case GT: 
            case LCMP: 
            case LE: 
            case LOCAL: 
            case LT: 
            case MUL: 
            case NE: 
            case NOT: 
            case OR: 
            case REM: 
            case SHL: 
            case SHR: 
            case SUB: 
            case USHR: 
            case XOR: {
                return true;
            }
        }
        return false;
    }

    static boolean isLocationInsensitive(Value op) {
        switch (op.et) {
            case E0: {
                return AggTransformer.isLocationInsensitive(op.vt);
            }
            case E1: {
                return AggTransformer.isLocationInsensitive(op.vt) && AggTransformer.isLocationInsensitive(op.getOp());
            }
            case E2: {
                return AggTransformer.isLocationInsensitive(op.vt) && AggTransformer.isLocationInsensitive(op.getOp1()) && AggTransformer.isLocationInsensitive(op.getOp2());
            }
            case En: {
                if (op.vt == Value.VT.INVOKE_STATIC) {
                    InvokeExpr ie = (InvokeExpr)op;
                    if (ie.name.equals("valueOf") && ie.owner.startsWith("Ljava/lang/") && ie.args.length == 1 && ie.args[0].length() == 1) {
                        Value[] valueArray = op.getOps();
                        int n = valueArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Value v = valueArray[n2];
                            if (!AggTransformer.isLocationInsensitive(v)) {
                                return false;
                            }
                            ++n2;
                        }
                        return true;
                    }
                    return false;
                }
                if (AggTransformer.isLocationInsensitive(op.vt)) {
                    Value[] valueArray = op.getOps();
                    int n = valueArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Value v = valueArray[n3];
                        if (!AggTransformer.isLocationInsensitive(v)) {
                            return false;
                        }
                        ++n3;
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    static class MergeResult
    extends Throwable {
        MergeResult() {
        }
    }

    static class ReplaceX
    implements Cfg.TravelCallBack {
        Local local;
        Value replaceWith;

        ReplaceX() {
        }

        @Override
        public Value onAssign(Local v, AssignStmt as) {
            return v;
        }

        @Override
        public Value onUse(Local v) {
            if (v == this.local) {
                return this.replaceWith;
            }
            return v;
        }
    }
}

