/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import com.google.common.collect.Range;
import db.util.ErrorHandler;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreValueCollection;
import ghidra.util.database.DirectedIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;

public class DBCachedObjectStoreValueSubCollection<T extends DBAnnotatedObject>
extends DBCachedObjectStoreValueCollection<T> {
    protected final Range<Long> keyRange;

    public DBCachedObjectStoreValueSubCollection(DBCachedObjectStore<T> store, ErrorHandler errHandler, ReadWriteLock lock, DirectedIterator.Direction direction, Range<Long> keyRange) {
        super(store, errHandler, lock, direction);
        this.keyRange = keyRange;
    }

    @Override
    public int size() {
        return this.store.getKeyCount(this.keyRange);
    }

    @Override
    public boolean isEmpty() {
        return !this.store.getKeysExist(this.keyRange);
    }

    @Override
    public boolean contains(Object o) {
        return this.store.safe(this.lock.readLock(), () -> this.store.objects.contains(o, this.keyRange));
    }

    @Override
    public Iterator<T> iterator() {
        return this.store.objects.iterator(this.direction, this.keyRange);
    }

    @Override
    public Object[] toArray() {
        return this.store.objects.toArray(this.direction, this.keyRange);
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.store.objects.toArray(this.direction, this.keyRange, a, this.store.getKeyCount(this.keyRange));
    }

    @Override
    public boolean remove(Object o) {
        return this.store.safe(this.lock.writeLock(), () -> this.store.objects.remove(o, this.keyRange));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.store.safe(this.lock.readLock(), () -> this.store.objects.containsAll(c, this.keyRange));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.store.safe(this.lock.writeLock(), () -> this.store.objects.removeAll(c, this.keyRange));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.store.objects.retain(c, this.keyRange);
    }

    @Override
    public void clear() {
        this.store.deleteKeys(this.keyRange);
    }
}

