/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import com.google.common.collect.Range;
import db.Field;
import db.util.ErrorHandler;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBCachedObjectStoreFoundKeysValueCollection;
import ghidra.util.database.DirectedIterator;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class DBCachedObjectIndex<K, T extends DBAnnotatedObject> {
    protected final DBCachedObjectStore<T> store;
    protected final ErrorHandler errHandler;
    protected final DBCachedObjectStoreFactory.DBFieldCodec<K, T, ?> codec;
    protected final int columnIndex;
    protected final Range<Field> fieldRange;
    protected final DirectedIterator.Direction direction;

    protected DBCachedObjectIndex(DBCachedObjectStore<T> store, ErrorHandler errHandler, DBCachedObjectStoreFactory.DBFieldCodec<K, T, ?> codec, int columnIndex, Range<Field> fieldRange, DirectedIterator.Direction direction) {
        this.store = store;
        this.errHandler = errHandler;
        this.codec = codec;
        this.columnIndex = columnIndex;
        this.fieldRange = fieldRange;
        this.direction = direction;
    }

    public DBCachedObjectStoreFoundKeysValueCollection<T> get(K key) {
        Object field = this.codec.encodeField(key);
        if (!this.fieldRange.contains(field)) {
            return null;
        }
        try {
            return this.store.findObjects(this.columnIndex, (Field)field);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
            return null;
        }
    }

    public Collection<T> getLazily(final K key) {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return DBCachedObjectIndex.this.get(key).iterator();
            }

            @Override
            public int size() {
                return DBCachedObjectIndex.this.countKey(key);
            }

            @Override
            public boolean isEmpty() {
                return !DBCachedObjectIndex.this.containsKey(key);
            }
        };
    }

    public T getOne(K value) {
        Object field = this.codec.encodeField(value);
        if (!this.fieldRange.contains(field)) {
            return null;
        }
        try {
            return this.store.findOneObject(this.columnIndex, (Field)field);
        }
        catch (IOException e) {
            this.errHandler.dbError(e);
            return null;
        }
    }

    public Iterable<K> keys() {
        return new Iterable<K>(){

            @Override
            public Iterator<K> iterator() {
                try {
                    final Iterator valueIterator = DBCachedObjectIndex.this.store.iterator(DBCachedObjectIndex.this.columnIndex, DBCachedObjectIndex.this.fieldRange, DBCachedObjectIndex.this.direction);
                    return new Iterator<K>(){

                        @Override
                        public boolean hasNext() {
                            return valueIterator.hasNext();
                        }

                        @Override
                        public K next() {
                            DBAnnotatedObject value = (DBAnnotatedObject)((Object)valueIterator.next());
                            return DBCachedObjectIndex.this.codec.getValue(value);
                        }
                    };
                }
                catch (IOException e) {
                    DBCachedObjectIndex.this.errHandler.dbError(e);
                    return null;
                }
            }
        };
    }

    public Iterable<T> values() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                try {
                    return DBCachedObjectIndex.this.store.iterator(DBCachedObjectIndex.this.columnIndex, DBCachedObjectIndex.this.fieldRange, DBCachedObjectIndex.this.direction);
                }
                catch (IOException e) {
                    DBCachedObjectIndex.this.errHandler.dbError(e);
                    return null;
                }
            }
        };
    }

    public Iterable<Map.Entry<K, T>> entries() {
        return new Iterable<Map.Entry<K, T>>(){

            @Override
            public Iterator<Map.Entry<K, T>> iterator() {
                try {
                    final Iterator valueIterator = DBCachedObjectIndex.this.store.iterator(DBCachedObjectIndex.this.columnIndex, DBCachedObjectIndex.this.fieldRange, DBCachedObjectIndex.this.direction);
                    return new Iterator<Map.Entry<K, T>>(){

                        @Override
                        public boolean hasNext() {
                            return valueIterator.hasNext();
                        }

                        @Override
                        public Map.Entry<K, T> next() {
                            DBAnnotatedObject value = (DBAnnotatedObject)((Object)valueIterator.next());
                            return Map.entry(DBCachedObjectIndex.this.codec.getValue(value), value);
                        }
                    };
                }
                catch (IOException e) {
                    DBCachedObjectIndex.this.errHandler.dbError(e);
                    return null;
                }
            }
        };
    }

    protected static <T> T firstOf(Iterable<T> of) {
        Iterator<T> it = of.iterator();
        return it.hasNext() ? (T)it.next() : null;
    }

    public boolean isEmpty() {
        return this.values().iterator().hasNext();
    }

    public boolean containsKey(K key) {
        Object field = this.codec.encodeField(key);
        if (!this.fieldRange.contains(field)) {
            return false;
        }
        try {
            return this.store.table.hasRecord(field, this.columnIndex);
        }
        catch (IOException e) {
            this.store.dbError(e);
            return false;
        }
    }

    public boolean containsValue(T value) {
        if (!this.fieldRange.contains((Comparable)((DBAnnotatedObject)((Object)value)).record.getFieldValue(this.columnIndex))) {
            return false;
        }
        return this.store.contains(value);
    }

    public int countKey(K key) {
        Object field = this.codec.encodeField(key);
        if (!this.fieldRange.contains(field)) {
            return 0;
        }
        try {
            return this.store.table.getMatchingRecordCount(field, this.columnIndex);
        }
        catch (IOException e) {
            this.store.dbError(e);
            return 0;
        }
    }

    public K firstKey() {
        return DBCachedObjectIndex.firstOf(this.keys());
    }

    public T firstValue() {
        return (T)((Object)((DBAnnotatedObject)((Object)DBCachedObjectIndex.firstOf(this.values()))));
    }

    public Map.Entry<K, T> firstEntry() {
        return DBCachedObjectIndex.firstOf(this.entries());
    }

    public K lastKey() {
        return DBCachedObjectIndex.firstOf(this.descending().keys());
    }

    public T lastValue() {
        return (T)((Object)((DBAnnotatedObject)((Object)DBCachedObjectIndex.firstOf(this.descending().values()))));
    }

    public Map.Entry<K, T> lastEntry() {
        return DBCachedObjectIndex.firstOf(this.descending().entries());
    }

    public K lowerKey(K key) {
        return DBCachedObjectIndex.firstOf(this.head(key, false).descending().keys());
    }

    public T lowerValue(K key) {
        return (T)((Object)((DBAnnotatedObject)((Object)DBCachedObjectIndex.firstOf(this.head(key, false).descending().values()))));
    }

    public Map.Entry<K, T> lowerEntry(K key) {
        return DBCachedObjectIndex.firstOf(this.head(key, false).descending().entries());
    }

    public K floorKey(K key) {
        return DBCachedObjectIndex.firstOf(this.head(key, true).descending().keys());
    }

    public T floorValue(K key) {
        return (T)((Object)((DBAnnotatedObject)((Object)DBCachedObjectIndex.firstOf(this.head(key, true).descending().values()))));
    }

    public Map.Entry<K, T> floorEntry(K key) {
        return DBCachedObjectIndex.firstOf(this.head(key, true).descending().entries());
    }

    public K ceilingKey(K key) {
        return DBCachedObjectIndex.firstOf(this.tail(key, true).keys());
    }

    public T ceilingValue(K key) {
        return (T)((Object)((DBAnnotatedObject)((Object)DBCachedObjectIndex.firstOf(this.tail(key, true).values()))));
    }

    public Map.Entry<K, T> ceilingEntry(K key) {
        return DBCachedObjectIndex.firstOf(this.tail(key, true).entries());
    }

    public K higherKey(K key) {
        return DBCachedObjectIndex.firstOf(this.tail(key, false).keys());
    }

    public T higherValue(K key) {
        return (T)((Object)((DBAnnotatedObject)((Object)DBCachedObjectIndex.firstOf(this.tail(key, false).values()))));
    }

    public Map.Entry<K, T> higherEntry(K key) {
        return DBCachedObjectIndex.firstOf(this.tail(key, false).entries());
    }

    public DBCachedObjectIndex<K, T> head(K to, boolean toInclusive) {
        Range<?> rng = DBCachedObjectStore.toRangeHead(this.codec.encodeField(to), toInclusive, this.direction);
        return new DBCachedObjectIndex<K, T>(this.store, this.errHandler, this.codec, this.columnIndex, (Range<Field>)this.fieldRange.intersection(rng), this.direction);
    }

    public DBCachedObjectIndex<K, T> tail(K from, boolean fromInclusive) {
        Range<?> rng = DBCachedObjectStore.toRangeTail(this.codec.encodeField(from), fromInclusive, this.direction);
        return new DBCachedObjectIndex<K, T>(this.store, this.errHandler, this.codec, this.columnIndex, (Range<Field>)this.fieldRange.intersection(rng), this.direction);
    }

    public DBCachedObjectIndex<K, T> sub(K from, boolean fromInclusive, K to, boolean toInclusive) {
        Range<?> rng = DBCachedObjectStore.toRange(this.codec.encodeField(from), fromInclusive, this.codec.encodeField(to), toInclusive, this.direction);
        return new DBCachedObjectIndex<K, T>(this.store, this.errHandler, this.codec, this.columnIndex, (Range<Field>)this.fieldRange.intersection(rng), this.direction);
    }

    public DBCachedObjectIndex<K, T> descending() {
        return new DBCachedObjectIndex<K, T>(this.store, this.errHandler, this.codec, this.columnIndex, this.fieldRange, DirectedIterator.Direction.reverse(this.direction));
    }
}

