/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.program.model.lang.Language;
import ghidra.program.model.pcode.PcodeOp;
import java.util.List;
import java.util.Map;

public class PcodeFrame {
    private final Language language;
    private final List<PcodeOp> code;
    private final Map<Integer, String> useropNames;
    private int index = 0;
    private int branched = -1;

    public PcodeFrame(Language language, List<PcodeOp> code, Map<Integer, String> useropNames) {
        this.language = language;
        this.code = code;
        this.useropNames = useropNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("<p-code frame: index=");
        sb.append(this.index);
        if (this.branched != -1) {
            sb.append(" branched=" + this.branched);
        }
        sb.append(" {");
        for (int i = 0; i < this.code.size(); ++i) {
            sb.append("\n");
            if (i == this.branched) {
                sb.append(" *>");
            } else if (i == this.index) {
                sb.append(" ->");
            } else {
                sb.append("   ");
            }
            PcodeOp op = this.code.get(i);
            sb.append(op.getSeqnum() + ": " + PcodeProgram.opToString(this.language, op, false));
        }
        if (this.index == this.code.size()) {
            sb.append("\n *> fall-through");
        }
        sb.append("\n}>");
        return sb.toString();
    }

    public int index() {
        return this.index;
    }

    public PcodeOp nextOp() {
        return this.code.get(this.advance());
    }

    public int advance() {
        return this.index++;
    }

    public int stepBack() {
        return this.index--;
    }

    public String getUseropName(int userop) {
        return this.useropNames.get(userop);
    }

    public boolean isFallThrough() {
        return this.index == this.code.size();
    }

    public boolean isBranch() {
        return this.index == -1;
    }

    public boolean isFinished() {
        return 0 > this.index || this.index >= this.code.size();
    }

    public void branch(int rel) {
        this.index += rel - 1;
        if (0 > this.index || this.index > this.code.size()) {
            throw new LowlevelError("Bad p-code branch");
        }
    }

    public void finishAsBranch() {
        this.branched = this.index - 1;
        this.index = -1;
    }

    public List<PcodeOp> getCode() {
        return this.code;
    }

    public PcodeOp[] copyCode() {
        return (PcodeOp[])this.code.toArray(PcodeOp[]::new);
    }

    public int getBranched() {
        return this.branched;
    }
}

