/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.spatial;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeIndexFunction;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.ParallelEdgeShapeTransformer;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FastRenderingGraph<V, E>
implements Graph<V, E> {
    protected Graph<V, E> graph;
    protected Set<V> vertices = new HashSet<V>();
    protected Set<E> edges = new HashSet();
    protected boolean dirty;
    protected Set<Rectangle2D> bounds;
    protected RenderContext<V, E> rc;
    protected BasicVisualizationServer<V, E> vv;
    protected Layout<V, E> layout;

    public FastRenderingGraph(Graph<V, E> graph, Set<Rectangle2D> bounds, BasicVisualizationServer<V, E> vv) {
        this.graph = graph;
        this.bounds = bounds;
        this.vv = vv;
        this.rc = vv.getRenderContext();
    }

    private void cleanUp() {
        this.vertices.clear();
        this.edges.clear();
        for (Object v : this.graph.getVertices()) {
            this.checkVertex(v);
        }
        for (Object e : this.graph.getEdges()) {
            this.checkEdge(e);
        }
    }

    private void checkVertex(V v) {
        Shape shape = (Shape)this.rc.getVertexShapeTransformer().apply(v);
        Point2D p = (Point2D)this.layout.apply(v);
        p = this.rc.getMultiLayerTransformer().transform(Layer.LAYOUT, p);
        float x = (float)p.getX();
        float y = (float)p.getY();
        AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
        shape = xform.createTransformedShape(shape);
        for (Rectangle2D r : this.bounds) {
            if (!shape.intersects(r)) continue;
            this.vertices.add(v);
        }
    }

    private void checkEdge(E e) {
        float dy;
        Pair<V> endpoints = this.graph.getEndpoints(e);
        V v1 = endpoints.getFirst();
        V v2 = endpoints.getSecond();
        Point2D p1 = (Point2D)this.layout.apply(v1);
        Point2D p2 = (Point2D)this.layout.apply(v2);
        p1 = this.rc.getMultiLayerTransformer().transform(Layer.LAYOUT, p1);
        p2 = this.rc.getMultiLayerTransformer().transform(Layer.LAYOUT, p2);
        float x1 = (float)p1.getX();
        float y1 = (float)p1.getY();
        float x2 = (float)p2.getX();
        float y2 = (float)p2.getY();
        boolean isLoop = v1.equals(v2);
        Shape s2 = (Shape)this.rc.getVertexShapeTransformer().apply(v2);
        Shape edgeShape = (Shape)this.rc.getEdgeShapeTransformer().apply(e);
        AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
        if (isLoop) {
            Rectangle2D s2Bounds = s2.getBounds2D();
            xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
            xform.translate(0.0, -edgeShape.getBounds2D().getWidth() / 2.0);
        } else if (this.rc.getEdgeShapeTransformer() instanceof EdgeShape.Orthogonal) {
            float dx = x2 - x1;
            dy = y2 - y1;
            int index = 0;
            if (this.rc.getEdgeShapeTransformer() instanceof ParallelEdgeShapeTransformer) {
                EdgeIndexFunction peif = ((ParallelEdgeShapeTransformer)this.rc.getEdgeShapeTransformer()).getEdgeIndexFunction();
                index = peif.getIndex(null, e);
                index *= 20;
            }
            GeneralPath gp = new GeneralPath();
            gp.moveTo(0.0f, 0.0f);
            if (x1 > x2) {
                if (y1 > y2) {
                    gp.lineTo(0.0f, index);
                    gp.lineTo(dx - (float)index, index);
                    gp.lineTo(dx - (float)index, dy);
                    gp.lineTo(dx, dy);
                } else {
                    gp.lineTo(0.0f, -index);
                    gp.lineTo(dx - (float)index, -index);
                    gp.lineTo(dx - (float)index, dy);
                    gp.lineTo(dx, dy);
                }
            } else if (y1 > y2) {
                gp.lineTo(0.0f, index);
                gp.lineTo(dx + (float)index, index);
                gp.lineTo(dx + (float)index, dy);
                gp.lineTo(dx, dy);
            } else {
                gp.lineTo(0.0f, -index);
                gp.lineTo(dx + (float)index, -index);
                gp.lineTo(dx + (float)index, dy);
                gp.lineTo(dx, dy);
            }
            edgeShape = gp;
        } else {
            float dx = x2 - x1;
            dy = y2 - y1;
            float thetaRadians = (float)Math.atan2(dy, dx);
            xform.rotate(thetaRadians);
            float dist = (float)Math.sqrt(dx * dx + dy * dy);
            xform.scale(dist, 1.0);
        }
        edgeShape = xform.createTransformedShape(edgeShape);
        for (Rectangle2D r : this.bounds) {
            if (!edgeShape.intersects(r)) continue;
            this.edges.add(e);
        }
    }

    public Set<Rectangle2D> getBounds() {
        return this.bounds;
    }

    public void setBounds(Set<Rectangle2D> bounds) {
        this.bounds = bounds;
    }

    @Override
    public boolean addEdge(E edge, Collection<? extends V> vertices, EdgeType edgeType) {
        return this.graph.addEdge(edge, (EdgeType)((Object)vertices), edgeType);
    }

    @Override
    public boolean addEdge(E edge, Collection<? extends V> vertices) {
        return this.graph.addEdge(edge, vertices);
    }

    @Override
    public boolean addEdge(E e, V v1, V v2, EdgeType edgeType) {
        return this.graph.addEdge(e, v1, v2, edgeType);
    }

    @Override
    public boolean addEdge(E e, V v1, V v2) {
        return this.graph.addEdge(e, v1, v2);
    }

    @Override
    public boolean addVertex(V vertex) {
        return this.graph.addVertex(vertex);
    }

    @Override
    public boolean containsEdge(E edge) {
        return this.graph.containsEdge(edge);
    }

    @Override
    public boolean containsVertex(V vertex) {
        return this.graph.containsVertex(vertex);
    }

    @Override
    public int degree(V vertex) {
        return this.graph.degree(vertex);
    }

    @Override
    public E findEdge(V v1, V v2) {
        return this.graph.findEdge(v1, v2);
    }

    @Override
    public Collection<E> findEdgeSet(V v1, V v2) {
        return this.graph.findEdgeSet(v1, v2);
    }

    @Override
    public EdgeType getDefaultEdgeType() {
        return this.graph.getDefaultEdgeType();
    }

    @Override
    public V getDest(E directedEdge) {
        return this.graph.getDest(directedEdge);
    }

    @Override
    public int getEdgeCount() {
        return this.graph.getEdgeCount();
    }

    @Override
    public int getEdgeCount(EdgeType edgeType) {
        return this.graph.getEdgeCount(edgeType);
    }

    @Override
    public Collection<E> getEdges() {
        if (this.dirty) {
            this.cleanUp();
        }
        return this.edges;
    }

    @Override
    public Collection<E> getEdges(EdgeType edgeType) {
        return this.graph.getEdges(edgeType);
    }

    @Override
    public EdgeType getEdgeType(E edge) {
        return this.graph.getEdgeType(edge);
    }

    @Override
    public Pair<V> getEndpoints(E edge) {
        return this.graph.getEndpoints(edge);
    }

    @Override
    public int getIncidentCount(E edge) {
        return this.graph.getIncidentCount(edge);
    }

    @Override
    public Collection<E> getIncidentEdges(V vertex) {
        return this.graph.getIncidentEdges(vertex);
    }

    @Override
    public Collection<V> getIncidentVertices(E edge) {
        return this.graph.getIncidentVertices(edge);
    }

    @Override
    public Collection<E> getInEdges(V vertex) {
        return this.graph.getInEdges(vertex);
    }

    @Override
    public int getNeighborCount(V vertex) {
        return this.graph.getNeighborCount(vertex);
    }

    @Override
    public Collection<V> getNeighbors(V vertex) {
        return this.graph.getNeighbors(vertex);
    }

    @Override
    public V getOpposite(V vertex, E edge) {
        return this.graph.getOpposite(vertex, edge);
    }

    @Override
    public Collection<E> getOutEdges(V vertex) {
        return this.graph.getOutEdges(vertex);
    }

    @Override
    public int getPredecessorCount(V vertex) {
        return this.graph.getPredecessorCount(vertex);
    }

    @Override
    public Collection<V> getPredecessors(V vertex) {
        return this.graph.getPredecessors(vertex);
    }

    @Override
    public V getSource(E directedEdge) {
        return this.graph.getSource(directedEdge);
    }

    @Override
    public int getSuccessorCount(V vertex) {
        return this.graph.getSuccessorCount(vertex);
    }

    @Override
    public Collection<V> getSuccessors(V vertex) {
        return this.graph.getSuccessors(vertex);
    }

    @Override
    public int getVertexCount() {
        return this.graph.getVertexCount();
    }

    @Override
    public Collection<V> getVertices() {
        if (this.dirty) {
            this.cleanUp();
        }
        return this.vertices;
    }

    @Override
    public int inDegree(V vertex) {
        return this.graph.inDegree(vertex);
    }

    @Override
    public boolean isDest(V vertex, E edge) {
        return this.graph.isDest(vertex, edge);
    }

    @Override
    public boolean isIncident(V vertex, E edge) {
        return this.graph.isIncident(vertex, edge);
    }

    @Override
    public boolean isNeighbor(V v1, V v2) {
        return this.graph.isNeighbor(v1, v2);
    }

    @Override
    public boolean isPredecessor(V v1, V v2) {
        return this.graph.isPredecessor(v1, v2);
    }

    @Override
    public boolean isSource(V vertex, E edge) {
        return this.graph.isSource(vertex, edge);
    }

    @Override
    public boolean isSuccessor(V v1, V v2) {
        return this.graph.isSuccessor(v1, v2);
    }

    @Override
    public int outDegree(V vertex) {
        return this.graph.outDegree(vertex);
    }

    @Override
    public boolean removeEdge(E edge) {
        return this.graph.removeEdge(edge);
    }

    @Override
    public boolean removeVertex(V vertex) {
        return this.graph.removeVertex(vertex);
    }
}

