/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlUtil;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.MultipleUris;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.Uri;
import org.forester.util.ForesterUtil;
import org.forester.util.TaxonomyUtil;

public class Taxonomy
implements PhylogenyData,
MultipleUris,
Comparable<Taxonomy> {
    private String _scientific_name;
    private String _common_name;
    private List<String> _synonyms;
    private String _authority;
    private Identifier _identifier;
    private String _taxonomy_code;
    private String _rank;
    private List<Uri> _uris;
    private List<String> _lineage;

    public Taxonomy() {
        this.init();
    }

    @Override
    public StringBuffer asSimpleText() {
        return this.asText();
    }

    @Override
    public Uri getUri(int n) {
        return this.getUris().get(n);
    }

    @Override
    public void addUri(Uri uri) {
        if (this.getUris() == null) {
            this.setUris(new ArrayList<Uri>());
        }
        this.getUris().add(uri);
    }

    @Override
    public StringBuffer asText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getIdentifier() != null) {
            stringBuffer.append("[");
            stringBuffer.append(this.getIdentifier().asSimpleText());
            stringBuffer.append("]");
        }
        if (!ForesterUtil.isEmpty(this.getTaxonomyCode())) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("[");
            stringBuffer.append(this.getTaxonomyCode());
            stringBuffer.append("]");
        }
        if (!ForesterUtil.isEmpty(this.getScientificName())) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.getScientificName());
            if (!ForesterUtil.isEmpty(this.getAuthority())) {
                stringBuffer.append(" (");
                stringBuffer.append(this.getAuthority());
                stringBuffer.append(")");
            }
        }
        if (!ForesterUtil.isEmpty(this.getCommonName())) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.getCommonName());
        }
        return stringBuffer;
    }

    @Override
    public PhylogenyData copy() {
        Taxonomy taxonomy = new Taxonomy();
        try {
            taxonomy.setTaxonomyCode(this.getTaxonomyCode());
        }
        catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
            phyloXmlDataFormatException.printStackTrace();
        }
        taxonomy.setScientificName(this.getScientificName());
        taxonomy.setCommonName(this.getCommonName());
        taxonomy.setAuthority(this.getAuthority());
        for (String object : this.getSynonyms()) {
            taxonomy.getSynonyms().add(object);
        }
        if (this.getIdentifier() != null) {
            taxonomy.setIdentifier((Identifier)this.getIdentifier().copy());
        } else {
            taxonomy.setIdentifier(null);
        }
        try {
            taxonomy.setRank(new String(this.getRank()));
        }
        catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
            phyloXmlDataFormatException.printStackTrace();
        }
        if (this.getUris() != null) {
            taxonomy.setUris(new ArrayList<Uri>());
            for (Uri uri : this.getUris()) {
                if (uri == null) continue;
                taxonomy.getUris().add(uri);
            }
        }
        if (this.getLineage() != null) {
            taxonomy.setLineage(new ArrayList<String>());
            for (String string : this.getLineage()) {
                if (string == null) continue;
                taxonomy.getLineage().add(string);
            }
        }
        return taxonomy;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + object + " [" + object.getClass() + "]");
        }
        return this.isEqual((Taxonomy)object);
    }

    public String getAuthority() {
        return this._authority;
    }

    public String getCommonName() {
        return this._common_name;
    }

    public Identifier getIdentifier() {
        return this._identifier;
    }

    public String getRank() {
        return this._rank;
    }

    public String getScientificName() {
        return this._scientific_name;
    }

    public List<String> getSynonyms() {
        if (this._synonyms == null) {
            this._synonyms = new ArrayList<String>();
        }
        return this._synonyms;
    }

    public String getTaxonomyCode() {
        return this._taxonomy_code;
    }

    @Override
    public List<Uri> getUris() {
        return this._uris;
    }

    public int hashCode() {
        if (this.getIdentifier() != null && !ForesterUtil.isEmpty(this.getIdentifier().getValue())) {
            return this.getIdentifier().hashCode();
        }
        if (!ForesterUtil.isEmpty(this.getTaxonomyCode())) {
            return this.getTaxonomyCode().hashCode();
        }
        if (!ForesterUtil.isEmpty(this.getScientificName())) {
            if (!ForesterUtil.isEmpty(this.getAuthority())) {
                return (this.getScientificName().toLowerCase() + this.getAuthority().toLowerCase()).hashCode();
            }
            return this.getScientificName().toLowerCase().hashCode();
        }
        return this.getCommonName().toLowerCase().hashCode();
    }

    public void init() {
        this.setScientificName("");
        this.setCommonName("");
        this.setIdentifier(null);
        try {
            this.setRank("");
        }
        catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
            phyloXmlDataFormatException.printStackTrace();
        }
        try {
            this.setTaxonomyCode("");
        }
        catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
            phyloXmlDataFormatException.printStackTrace();
        }
        this.setAuthority("");
        this.setSynonyms(null);
        this.setUris(null);
        this.setLineage(null);
    }

    public boolean isEmpty() {
        return this.getIdentifier() == null && ForesterUtil.isEmpty(this.getTaxonomyCode()) && ForesterUtil.isEmpty(this.getCommonName()) && ForesterUtil.isEmpty(this.getScientificName()) && ForesterUtil.isEmpty(this._lineage);
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        if (this == phylogenyData) {
            return true;
        }
        Taxonomy taxonomy = (Taxonomy)phylogenyData;
        if (this.getIdentifier() != null && taxonomy.getIdentifier() != null && !ForesterUtil.isEmpty(this.getIdentifier().getValue()) && !ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue())) {
            return this.getIdentifier().isEqual(taxonomy.getIdentifier());
        }
        if (!ForesterUtil.isEmpty(this.getTaxonomyCode()) && !ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
            return this.getTaxonomyCode().equals(taxonomy.getTaxonomyCode());
        }
        if (!ForesterUtil.isEmpty(this.getScientificName()) && !ForesterUtil.isEmpty(taxonomy.getScientificName())) {
            if (!ForesterUtil.isEmpty(this.getAuthority()) && !ForesterUtil.isEmpty(taxonomy.getAuthority())) {
                return this.getScientificName().equalsIgnoreCase(taxonomy.getScientificName()) && this.getAuthority().equalsIgnoreCase(taxonomy.getAuthority());
            }
            return this.getScientificName().equalsIgnoreCase(taxonomy.getScientificName());
        }
        if (!ForesterUtil.isEmpty(this.getCommonName()) && !ForesterUtil.isEmpty(taxonomy.getCommonName())) {
            return this.getCommonName().equalsIgnoreCase(taxonomy.getCommonName());
        }
        return false;
    }

    public void setAuthority(String string) {
        this._authority = string;
    }

    public void setCommonName(String string) {
        this._common_name = string;
    }

    public void setIdentifier(Identifier identifier) {
        this._identifier = identifier;
    }

    public void setRank(String string) throws PhyloXmlDataFormatException {
        if (!ForesterUtil.isEmpty(string) && !TaxonomyUtil.TAXONOMY_RANKS_SET.contains(string)) {
            throw new PhyloXmlDataFormatException("illegal rank: [" + string + "]");
        }
        this._rank = string;
    }

    public void setScientificName(String string) {
        this._scientific_name = string;
    }

    private void setSynonyms(List<String> list) {
        this._synonyms = list;
    }

    public void setTaxonomyCode(String string) throws PhyloXmlDataFormatException {
        if (!ForesterUtil.isEmpty(string) && !PhyloXmlUtil.TAXOMONY_CODE_PATTERN.matcher(string).matches()) {
            throw new PhyloXmlDataFormatException("illegal taxonomy code: [" + string + "]");
        }
        this._taxonomy_code = string;
    }

    @Override
    public void setUris(List<Uri> list) {
        this._uris = list;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getIdentifier() != null) {
            stringBuffer.append(":T=");
            stringBuffer.append(ForesterUtil.replaceIllegalNhxCharacters(this.getIdentifier().getValue()));
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getTaxonomyCode())) {
            stringBuffer2.append(ForesterUtil.replaceIllegalNhxCharacters(this.getTaxonomyCode()));
        }
        if (!ForesterUtil.isEmpty(this.getScientificName())) {
            ForesterUtil.appendSeparatorIfNotEmpty(stringBuffer2, '|');
            stringBuffer2.append(ForesterUtil.replaceIllegalNhxCharacters(this.getScientificName()));
        }
        if (!ForesterUtil.isEmpty(this.getCommonName())) {
            ForesterUtil.appendSeparatorIfNotEmpty(stringBuffer2, '|');
            stringBuffer2.append(ForesterUtil.replaceIllegalNhxCharacters(this.getCommonName()));
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(":S=");
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer;
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendOpen(writer, "taxonomy");
        if (this.getIdentifier() != null && !ForesterUtil.isEmpty(this.getIdentifier().getValue())) {
            this.getIdentifier().toPhyloXML(writer, n, string);
        }
        if (!ForesterUtil.isEmpty(this.getTaxonomyCode())) {
            PhylogenyDataUtil.appendElement(writer, "code", this.getTaxonomyCode(), string);
        }
        if (!ForesterUtil.isEmpty(this.getScientificName())) {
            PhylogenyDataUtil.appendElement(writer, "scientific_name", this.getScientificName(), string);
        }
        if (!ForesterUtil.isEmpty(this.getAuthority())) {
            PhylogenyDataUtil.appendElement(writer, "authority", this.getAuthority(), string);
        }
        if (!ForesterUtil.isEmpty(this.getCommonName())) {
            PhylogenyDataUtil.appendElement(writer, "common_name", this.getCommonName(), string);
        }
        if (this._synonyms != null) {
            for (String object : this.getSynonyms()) {
                if (ForesterUtil.isEmpty(object)) continue;
                PhylogenyDataUtil.appendElement(writer, "synonym", object, string);
            }
        }
        if (!ForesterUtil.isEmpty(this.getRank())) {
            PhylogenyDataUtil.appendElement(writer, "rank", this.getRank(), string);
        }
        if (this.getUris() != null) {
            for (Uri uri : this.getUris()) {
                if (uri == null) continue;
                uri.toPhyloXML(writer, n, string);
            }
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendClose(writer, "taxonomy");
    }

    public String toString() {
        return this.asText().toString();
    }

    @Override
    public int compareTo(Taxonomy taxonomy) {
        int n;
        if (this.equals(taxonomy)) {
            return 0;
        }
        if (this.getIdentifier() != null && taxonomy.getIdentifier() != null && !ForesterUtil.isEmpty(this.getIdentifier().getValue()) && !ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue()) && (n = this.getIdentifier().getValuePlusProvider().compareTo(taxonomy.getIdentifier().getValuePlusProvider())) != 0) {
            return n;
        }
        if (!ForesterUtil.isEmpty(this.getScientificName()) && !ForesterUtil.isEmpty(taxonomy.getScientificName())) {
            return this.getScientificName().compareToIgnoreCase(taxonomy.getScientificName());
        }
        if (!ForesterUtil.isEmpty(this.getCommonName()) && !ForesterUtil.isEmpty(taxonomy.getCommonName())) {
            return this.getCommonName().compareToIgnoreCase(taxonomy.getCommonName());
        }
        if (!ForesterUtil.isEmpty(this.getTaxonomyCode()) && !ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
            return this.getTaxonomyCode().compareToIgnoreCase(taxonomy.getTaxonomyCode());
        }
        if (this.getIdentifier() != null && taxonomy.getIdentifier() != null && !ForesterUtil.isEmpty(this.getIdentifier().getValue()) && !ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue())) {
            return this.getIdentifier().getValuePlusProvider().compareTo(taxonomy.getIdentifier().getValuePlusProvider());
        }
        return 1;
    }

    public void setLineage(List<String> list) {
        this._lineage = list;
    }

    public List<String> getLineage() {
        return this._lineage;
    }
}

