/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class BarChartRenderer
extends AbstractChartRenderer {
    protected DecimalFormat barTopFormat;
    protected float boxWidth = 1.0f;
    protected Font barTopFont;

    public BarChartRenderer(CoordSystem cs, ChartDataModel model) {
        super(cs, model);
    }

    public BarChartRenderer(CoordSystem cs, ChartDataModel model, DecimalFormat topFormat, Font topFont, float boxWidth) {
        super(cs, model);
        this.barTopFormat = topFormat;
        this.barTopFont = topFont;
        this.boxWidth = boxWidth;
    }

    @Override
    public boolean renderChart(Graphics2D g) {
        ChartDataModel m = this.getChartDataModel();
        ChartDataModelConstraints con = m.getChartDataModelConstraints(0);
        if (m.isColumnNumeric()) {
            return false;
        }
        RowColorModel rcm = this.getRowColorModel();
        AffineTransform yaxis1 = this.getTransform(0);
        AffineTransform yaxis2 = this.getTransform(1);
        int datasetcount = m.getDataSetNumber();
        Point2D point1 = yaxis1.transform(new Point2D.Float(con.getMinimumX().floatValue(), con.getMaximumY().floatValue()), null);
        Point2D point2 = yaxis1.transform(new Point2D.Float(con.getMaximumX().floatValue(), con.getMaximumY().floatValue()), null);
        Point2D value = point1;
        int dataunitwidth = 1;
        if (con.getMaximumX().intValue() != 0) {
            dataunitwidth = (int)((point2.getX() - point1.getX()) / Math.abs(con.getMaximumX().doubleValue()));
        } else if (con.getMinimumX().intValue() != 0) {
            dataunitwidth = (int)((point2.getX() - point1.getX()) / Math.abs(con.getMinimumX().doubleValue()));
        }
        int boxwidth = (int)((float)dataunitwidth * this.boxWidth / (float)datasetcount);
        float margin = (float)((double)dataunitwidth * ((1.0 - (double)this.boxWidth) / 2.0));
        Point2D pointzero = con.getMinimumY().floatValue() > 0.0f ? yaxis1.transform(new Point2D.Float(con.getMinimumX().floatValue(), con.getMinimumY().floatValue()), null) : (con.getMaximumY().floatValue() < 0.0f ? yaxis1.transform(new Point2D.Float(con.getMinimumX().floatValue(), con.getMaximumY().floatValue()), null) : yaxis1.transform(new Point2D.Float(con.getMinimumX().floatValue(), 0.0f), null));
        FontRenderContext columnTopfrc = null;
        LineMetrics lm = null;
        Object df = null;
        Rectangle2D fontRec = null;
        String columnTop = null;
        if (this.barTopFormat != null) {
            g.setFont(this.barTopFont);
            columnTopfrc = new FontRenderContext(null, false, false);
        }
        int i = 0;
        while (i < datasetcount && !this.getStopFlag()) {
            int j = 0;
            while (j < m.getDataSetLength(i) && !this.getStopFlag()) {
                yaxis1.transform(new Point2D.Float(j, m.getValueAt(i, j).floatValue()), value);
                Rectangle2D.Float box = new Rectangle2D.Float((float)(value.getX() + (double)margin + (double)(i * boxwidth)), (float)Math.min(value.getY(), pointzero.getY()), boxwidth, (float)Math.abs(pointzero.getY() - value.getY()));
                g.setColor(rcm.getColor(i));
                g.fill(box);
                g.setColor(Color.black);
                g.draw(box);
                if (this.barTopFormat != null) {
                    columnTop = this.barTopFormat.format(this.model.getValueAt(i, j).doubleValue());
                    fontRec = this.barTopFont.getStringBounds(columnTop, columnTopfrc);
                    lm = this.barTopFont.getLineMetrics(columnTop, columnTopfrc);
                    g.drawString(columnTop, (float)(value.getX() + (double)(i * boxwidth) + ((double)boxwidth - fontRec.getWidth()) / 2.0) - lm.getLeading(), (float)(Math.min(value.getY(), pointzero.getY()) - (double)lm.getDescent()));
                }
                ++j;
            }
            ++i;
        }
        boolean completed = !this.getStopFlag();
        this.resetStopFlag();
        return completed;
    }
}

