/*
 * Decompiled with CFR 0.152.
 */
package org.encog.plugin.system;

import org.encog.EncogError;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.factory.method.BayesianFactory;
import org.encog.ml.factory.method.EPLFactory;
import org.encog.ml.factory.method.FeedforwardFactory;
import org.encog.ml.factory.method.NEATFactory;
import org.encog.ml.factory.method.PNNFactory;
import org.encog.ml.factory.method.RBFNetworkFactory;
import org.encog.ml.factory.method.SOMFactory;
import org.encog.ml.factory.method.SVMFactory;
import org.encog.ml.train.MLTrain;
import org.encog.plugin.EncogPluginService1;

public class SystemMethodsPlugin
implements EncogPluginService1 {
    private final FeedforwardFactory feedforwardFactory = new FeedforwardFactory();
    private final SVMFactory svmFactory = new SVMFactory();
    private final RBFNetworkFactory rbfFactory = new RBFNetworkFactory();
    private final PNNFactory pnnFactory = new PNNFactory();
    private final SOMFactory somFactory = new SOMFactory();
    private final BayesianFactory bayesianFactory = new BayesianFactory();
    private final NEATFactory neatFactory = new NEATFactory();
    private final EPLFactory eplFactory = new EPLFactory();

    @Override
    public final String getPluginDescription() {
        return "This plugin provides the built in machine learning methods for Encog.";
    }

    @Override
    public final String getPluginName() {
        return "HRI-System-Methods";
    }

    @Override
    public final int getPluginType() {
        return 1;
    }

    @Override
    public ActivationFunction createActivationFunction(String name) {
        return null;
    }

    @Override
    public MLMethod createMethod(String methodType, String architecture, int input, int output) {
        if ("feedforward".equals(methodType)) {
            return this.feedforwardFactory.create(architecture, input, output);
        }
        if ("rbfnetwork".equals(methodType)) {
            return this.rbfFactory.create(architecture, input, output);
        }
        if ("svm".equals(methodType)) {
            return this.svmFactory.create(architecture, input, output);
        }
        if ("som".equals(methodType)) {
            return this.somFactory.create(architecture, input, output);
        }
        if ("pnn".equals(methodType)) {
            return this.pnnFactory.create(architecture, input, output);
        }
        if ("bayesian".equals(methodType)) {
            return this.bayesianFactory.create(architecture, input, output);
        }
        if ("neat".equals(methodType)) {
            return this.neatFactory.create(architecture, input, output);
        }
        if ("epl".equals(methodType)) {
            return this.eplFactory.create(architecture, input, output);
        }
        throw new EncogError("Unknown method type: " + methodType);
    }

    @Override
    public MLTrain createTraining(MLMethod method, MLDataSet training, String type, String args) {
        return null;
    }

    @Override
    public int getPluginServiceType() {
        return 0;
    }
}

