/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat.training;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.encog.EncogError;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.ml.ea.genome.BasicGenome;
import org.encog.ml.ea.genome.Genome;
import org.encog.neural.neat.NEATNeuronType;
import org.encog.neural.neat.NEATPopulation;
import org.encog.neural.neat.training.NEATBaseGene;
import org.encog.neural.neat.training.NEATLinkGene;
import org.encog.neural.neat.training.NEATNeuronGene;
import org.encog.util.Format;

public class NEATGenome
extends BasicGenome
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int inputCount;
    private final List<NEATLinkGene> linksList = new ArrayList<NEATLinkGene>();
    private int networkDepth;
    private final List<NEATNeuronGene> neuronsList = new ArrayList<NEATNeuronGene>();
    private int outputCount;

    public NEATGenome(NEATGenome other) {
        NEATBaseGene newGene;
        this.networkDepth = other.networkDepth;
        this.setPopulation(other.getPopulation());
        this.setScore(other.getScore());
        this.setAdjustedScore(other.getAdjustedScore());
        this.inputCount = other.inputCount;
        this.outputCount = other.outputCount;
        this.setSpecies(other.getSpecies());
        for (NEATNeuronGene nEATNeuronGene : other.getNeuronsChromosome()) {
            newGene = new NEATNeuronGene(nEATNeuronGene);
            this.neuronsList.add((NEATNeuronGene)newGene);
        }
        for (NEATLinkGene nEATLinkGene : other.getLinksChromosome()) {
            newGene = new NEATLinkGene(nEATLinkGene.getFromNeuronID(), nEATLinkGene.getToNeuronID(), nEATLinkGene.isEnabled(), nEATLinkGene.getInnovationId(), nEATLinkGene.getWeight());
            this.linksList.add((NEATLinkGene)newGene);
        }
    }

    public NEATGenome(List<NEATNeuronGene> neurons, List<NEATLinkGene> links, int inputCount, int outputCount) {
        this.setAdjustedScore(0.0);
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        for (NEATLinkGene gene : links) {
            this.linksList.add(new NEATLinkGene(gene));
        }
        this.neuronsList.addAll(neurons);
    }

    public NEATGenome(Random rnd, NEATPopulation pop, int inputCount, int outputCount, double connectionDensity) {
        NEATNeuronGene gene;
        int i;
        this.setAdjustedScore(0.0);
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        ActivationFunction af = pop.getActivationFunctions().pickFirst();
        int innovationID = 0;
        NEATNeuronGene biasGene = new NEATNeuronGene(NEATNeuronType.Bias, af, inputCount, innovationID++);
        this.neuronsList.add(biasGene);
        for (i = 0; i < inputCount; ++i) {
            gene = new NEATNeuronGene(NEATNeuronType.Input, af, i, innovationID++);
            this.neuronsList.add(gene);
        }
        for (i = 0; i < outputCount; ++i) {
            gene = new NEATNeuronGene(NEATNeuronType.Output, af, i + inputCount + 1, innovationID++);
            this.neuronsList.add(gene);
        }
        for (i = 0; i < inputCount + 1; ++i) {
            for (int j = 0; j < outputCount; ++j) {
                if (this.linksList.size() >= 1 && !(rnd.nextDouble() < connectionDensity)) continue;
                long fromID = this.neuronsList.get(i).getId();
                long toID = this.neuronsList.get(inputCount + j + 1).getId();
                double w = RangeRandomizer.randomize(rnd, -pop.getWeightRange(), pop.getWeightRange());
                NEATLinkGene gene2 = new NEATLinkGene(fromID, toID, true, innovationID++, w);
                this.linksList.add(gene2);
            }
        }
    }

    public NEATGenome() {
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public int getNetworkDepth() {
        return this.networkDepth;
    }

    public int getNumGenes() {
        return this.linksList.size();
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public void setNetworkDepth(int networkDepth) {
        this.networkDepth = networkDepth;
    }

    public void sortGenes() {
        Collections.sort(this.linksList);
    }

    public List<NEATLinkGene> getLinksChromosome() {
        return this.linksList;
    }

    public List<NEATNeuronGene> getNeuronsChromosome() {
        return this.neuronsList;
    }

    public void setInputCount(int inputCount) {
        this.inputCount = inputCount;
    }

    public void setOutputCount(int outputCount) {
        this.outputCount = outputCount;
    }

    public void validate() {
        NEATNeuronGene g = this.neuronsList.get(0);
        if (g.getNeuronType() != NEATNeuronType.Bias) {
            throw new EncogError("NEAT Neuron Gene 0 should be a bias gene.");
        }
        for (int i = 1; i <= this.inputCount; ++i) {
            NEATNeuronGene gene = this.neuronsList.get(i);
            if (gene.getNeuronType() == NEATNeuronType.Input) continue;
            throw new EncogError("NEAT Neuron Gene " + i + " should be an input gene.");
        }
        HashMap<String, NEATLinkGene> map = new HashMap<String, NEATLinkGene>();
        for (NEATLinkGene nlg : this.linksList) {
            String key = nlg.getFromNeuronID() + "->" + nlg.getToNeuronID();
            if (map.containsKey(key)) {
                throw new EncogError("Double link found: " + key);
            }
            map.put(key, nlg);
        }
    }

    @Override
    public void copy(Genome source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.linksList.size();
    }

    public NEATNeuronGene findNeuron(long nodeID) {
        for (NEATNeuronGene gene : this.neuronsList) {
            if (gene.getId() != nodeID) continue;
            return gene;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        result.append(this.getClass().getSimpleName());
        result.append(",score=");
        result.append(Format.formatDouble(this.getScore(), 2));
        result.append(",adjusted score=");
        result.append(Format.formatDouble(this.getAdjustedScore(), 2));
        result.append(",birth generation=");
        result.append(this.getBirthGeneration());
        result.append(",neurons=");
        result.append(this.neuronsList.size());
        result.append(",links=");
        result.append(this.linksList.size());
        result.append("]");
        return result.toString();
    }
}

