/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.bayesian;

import java.io.Serializable;
import org.encog.util.csv.CSVFormat;

public class BayesianChoice
implements Serializable,
Comparable<BayesianChoice> {
    private final String label;
    final double min;
    final double max;

    public BayesianChoice(String label, double min, double max) {
        this.label = label;
        this.min = min;
        this.max = max;
    }

    public BayesianChoice(String label, int index) {
        this.label = label;
        this.min = index;
        this.max = index;
    }

    public String getLabel() {
        return this.label;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean isIndex() {
        return Math.abs(this.min - this.max) < 1.0E-13;
    }

    public String toString() {
        return this.label;
    }

    public String toFullString() {
        StringBuilder result = new StringBuilder();
        result.append(this.label);
        if (!this.isIndex()) {
            result.append(":");
            result.append(CSVFormat.EG_FORMAT.format(this.min, 4));
            result.append(" to ");
            result.append(CSVFormat.EG_FORMAT.format(this.max, 4));
        }
        return result.toString();
    }

    @Override
    public int compareTo(BayesianChoice other) {
        if (this.max < other.max) {
            return -1;
        }
        return 1;
    }
}

