/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.csv.TimeSeriesUtil;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.app.analyst.csv.basic.LoadedRow;
import org.encog.app.analyst.csv.normalize.AnalystNormalizeCSV;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.app.analyst.util.CSVHeaders;
import org.encog.app.quant.QuantError;
import org.encog.ml.MLClassification;
import org.encog.ml.MLMethod;
import org.encog.ml.MLRegression;
import org.encog.ml.bayesian.BayesianNetwork;
import org.encog.ml.data.MLData;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.util.arrayutil.ClassItem;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class AnalystEvaluateCSV
extends BasicFile {
    private EncogAnalyst analyst;
    private int fileColumns;
    private int outputColumns;
    private TimeSeriesUtil series;
    private CSVHeaders analystHeaders;

    public void analyze(EncogAnalyst theAnalyst, File inputFile, boolean headers, CSVFormat format) {
        this.setInputFilename(inputFile);
        this.setExpectInputHeaders(headers);
        this.setInputFormat(format);
        this.setAnalyzed(true);
        this.analyst = theAnalyst;
        this.performBasicCounts();
        this.fileColumns = this.getInputHeadings().length;
        this.outputColumns = this.analyst.determineOutputFieldCount();
        this.analystHeaders = new CSVHeaders(this.getInputHeadings());
        this.series = new TimeSeriesUtil(this.analyst, false, this.analystHeaders.getHeaders());
    }

    private PrintWriter prepareOutputFile(MLMethod method, File outputFile, int input, int output) {
        try {
            PrintWriter tw = new PrintWriter(new FileWriter(outputFile));
            if (this.isProduceOutputHeaders()) {
                StringBuilder line = new StringBuilder();
                for (String heading : this.getInputHeadings()) {
                    BasicFile.appendSeparator(line, this.getFormat());
                    line.append("\"");
                    line.append(heading);
                    line.append("\"");
                }
                for (AnalystField field : this.analyst.getScript().getNormalize().getNormalizedFields()) {
                    if (!field.isOutput() || field.isIgnored()) continue;
                    BasicFile.appendSeparator(line, this.getFormat());
                    line.append("\"Output:");
                    line.append(CSVHeaders.tagColumn(field.getName(), 0, field.getTimeSlice(), false));
                    line.append("\"");
                }
                String otherOutput = "";
                if (method instanceof BayesianNetwork) {
                    otherOutput = ((BayesianNetwork)method).getClassificationTargetEvent().getLabel();
                    BasicFile.appendSeparator(line, this.getFormat());
                    line.append("\"Output:");
                    line.append(otherOutput);
                    line.append("\"");
                }
                tw.println(line.toString());
            }
            return tw;
        }
        catch (IOException e) {
            throw new QuantError(e);
        }
    }

    public void process(File outputFile, MLMethod method) {
        ReadCSV csv = new ReadCSV(this.getInputFilename().toString(), this.isExpectInputHeaders(), this.getFormat());
        MLData output = null;
        for (AnalystField field : this.analyst.getScript().getNormalize().getNormalizedFields()) {
            field.init();
        }
        int outputLength = this.analyst.determineTotalInputFieldCount();
        PrintWriter tw = this.prepareOutputFile(method, outputFile, this.analyst.getScript().getNormalize().countActiveFields() - 1, 1);
        this.resetStatus();
        while (csv.next()) {
            this.updateStatus(false);
            LoadedRow row = new LoadedRow(csv, this.outputColumns);
            double[] inputArray = AnalystNormalizeCSV.extractFields(this.analyst, this.analystHeaders, csv, outputLength, true);
            if (this.series.getTotalDepth() > 1) {
                inputArray = this.series.process(inputArray);
            }
            if (inputArray != null) {
                BasicMLData input = new BasicMLData(inputArray);
                if (method instanceof MLClassification && !(method instanceof MLRegression)) {
                    output = new BasicMLData(1);
                    output.setData(0, ((MLClassification)method).classify(input));
                } else {
                    output = ((MLRegression)method).compute(input);
                }
                int index = this.fileColumns;
                int outputIndex = 0;
                String otherOutput = "";
                if (method instanceof BayesianNetwork) {
                    otherOutput = ((BayesianNetwork)method).getClassificationTargetEvent().getLabel();
                }
                for (AnalystField field : this.analyst.getScript().getNormalize().getNormalizedFields()) {
                    if (this.analystHeaders.find(field.getName()) == -1 || !field.isOutput() && !field.getName().equals(otherOutput)) continue;
                    if (field.isClassify()) {
                        ClassItem cls = field.determineClass(outputIndex, output.getData());
                        outputIndex += field.getColumnsNeeded();
                        if (cls == null) {
                            row.getData()[index++] = "?Unknown?";
                            continue;
                        }
                        row.getData()[index++] = cls.getName();
                        continue;
                    }
                    double n = output.getData(outputIndex++);
                    n = field.deNormalize(n);
                    row.getData()[index++] = this.getFormat().format(n, this.getPrecision());
                }
            }
            this.writeRow(tw, row);
        }
        this.reportDone(false);
        tw.close();
        csv.close();
    }
}

