/*
 * Decompiled with CFR 0.152.
 */
package spl;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.GZIPOutputStream;

public class Tools {
    public static int WEBSERVICE_APP_ID = 9;
    public static String WEBSERVICE_VERSION_SHORT = "0.1";

    public static byte[] zip(File file) {
        try {
            int len;
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(bos);
            byte[] buf = new byte[1024];
            while ((len = fileInputStream.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            fileInputStream.close();
            out.finish();
            out.close();
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getStackTraceAsString(Exception exception) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(" [ ");
        pw.print(exception.getClass().getName());
        pw.print(" ] ");
        pw.print(exception.getMessage());
        exception.printStackTrace(pw);
        return sw.toString();
    }

    public static void centerRelativeToWindow(Dialog diag, Container win) {
        Point topLeft = win.getLocationOnScreen();
        Dimension parentSize = win.getSize();
        Dimension mySize = diag.getSize();
        int x = parentSize.width > mySize.width ? (parentSize.width - mySize.width) / 2 + topLeft.x : topLeft.x;
        int y = parentSize.height > mySize.height ? (parentSize.height - mySize.height) / 2 + topLeft.y : topLeft.y;
        diag.setLocation(x, y);
    }

    public static String getLink(String link, URL mindmapUrl) {
        block8: {
            if (link == null || link.isEmpty()) {
                return null;
            }
            if (!Tools.isAbsolutePath(link)) {
                try {
                    if (link.startsWith("\\\\")) {
                        link = link.replace("\\\\", "file://");
                        link = link.replace('\\', '/').replaceAll(" ", "%20");
                        URL url = new URL(link);
                        File file = new File(url.toURI());
                        return file.getPath();
                    }
                    if (mindmapUrl != null) {
                        URL url = new URL(mindmapUrl, link);
                        File file = new File(url.toURI());
                        return file.getPath();
                    }
                    break block8;
                }
                catch (MalformedURLException e) {
                    return link;
                }
                catch (URISyntaxException e) {
                    return link;
                }
                catch (IllegalArgumentException e) {
                    return link;
                }
            }
            return link;
        }
        return link;
    }

    public static boolean isAbsolutePath(String path) {
        String osNameStart = System.getProperty("os.name").substring(0, 3);
        String fileSeparator = System.getProperty("file.separator");
        if (osNameStart.equals("Win")) {
            return path.length() > 1 && path.substring(1, 2).equals(":") || path.startsWith(fileSeparator) && !path.startsWith("\\\\");
        }
        if (osNameStart.equals("Mac")) {
            return path.startsWith(fileSeparator);
        }
        return path.startsWith(fileSeparator);
    }
}

