/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.DatabaseChangeEvent;
import net.sf.jabref.DatabaseChangeListener;
import net.sf.jabref.IdComparator;

public class GlazedEntrySorter
implements DatabaseChangeListener {
    EventList<BibtexEntry> list = new BasicEventList<BibtexEntry>();
    String[] idArray;
    BibtexEntry[] entryArray;

    public GlazedEntrySorter(Map<String, BibtexEntry> entries) {
        this.list.getReadWriteLock().writeLock().lock();
        Set<String> keySet = entries.keySet();
        if (keySet != null) {
            Iterator<String> i = keySet.iterator();
            while (i.hasNext()) {
                this.list.add(entries.get(i.next()));
            }
        }
        Collections.sort(this.list, new IdComparator());
        this.list.getReadWriteLock().writeLock().unlock();
    }

    public EventList<BibtexEntry> getTheList() {
        return this.list;
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
        int index;
        this.list.getReadWriteLock().writeLock().lock();
        if (e.getType() == DatabaseChangeEvent.ChangeType.ADDED_ENTRY) {
            this.list.add(e.getEntry());
        } else if (e.getType() == DatabaseChangeEvent.ChangeType.REMOVED_ENTRY) {
            this.list.remove(e.getEntry());
        } else if (e.getType() == DatabaseChangeEvent.ChangeType.CHANGED_ENTRY && (index = this.list.indexOf(e.getEntry())) != -1) {
            this.list.set(index, e.getEntry());
        }
        this.list.getReadWriteLock().writeLock().unlock();
    }
}

