/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.bst;

import net.sf.jabref.bst.Warn;

public class BibtexCaseChanger {
    String s;
    char format;
    boolean prevColon = true;
    int n;
    Warn warn;
    int braceLevel = 0;
    public static final char TITLE_LOWERS = 't';
    public static final char ALL_LOWERS = 'l';
    public static final char ALL_UPPERS = 'u';

    BibtexCaseChanger(String s, char format, Warn warn) {
        this.s = s;
        this.format = format;
        this.n = s.length();
        this.warn = warn;
    }

    public static String changeCase(String s, char format, Warn warn) {
        return new BibtexCaseChanger(s, format, warn).changeCase();
    }

    private String changeCase() {
        char[] c = this.s.toCharArray();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.n) {
            if (c[i] == '{') {
                ++this.braceLevel;
                if (this.braceLevel != 1 || i + 4 > this.n || c[i + 1] != '\\') {
                    this.prevColon = false;
                    sb.append(c[i]);
                    ++i;
                    continue;
                }
                if (this.format == 't' && (i == 0 || this.prevColon && Character.isWhitespace(c[i - 1]))) {
                    sb.append(c[i]);
                    ++i;
                    this.prevColon = false;
                    continue;
                }
                i = this.convertSpecialChar(sb, c, i, this.format);
                continue;
            }
            if (c[i] == '}') {
                sb.append(c[i]);
                ++i;
                this.braceLevel = this.decrBraceLevel(this.s, this.braceLevel);
                this.prevColon = false;
                continue;
            }
            if (this.braceLevel == 0) {
                i = this.convertChar0(c, i, sb, this.format);
                continue;
            }
            sb.append(c[i]);
            ++i;
        }
        BibtexCaseChanger.checkBrace(this.s, this.braceLevel);
        return sb.toString();
    }

    int decrBraceLevel(String string, int braceLevel) {
        if (braceLevel == 0) {
            BibtexCaseChanger.complain(string);
        } else {
            --braceLevel;
        }
        return braceLevel;
    }

    static void complain(String s) {
        System.out.println("Warning -- String is not brace-balanced: " + s);
    }

    static void checkBrace(String s, int braceLevel) {
        if (braceLevel > 0) {
            BibtexCaseChanger.complain(s);
        }
    }

    public int convertSpecialChar(StringBuffer sb, char[] c, int i, char format) {
        sb.append(c[i]);
        ++i;
        while (i < c.length && this.braceLevel > 0) {
            sb.append(c[i]);
            String s = BibtexCaseChanger.findSpecialChar(c, ++i);
            if (s != null) {
                i = this.convertAccented(c, i, s, sb, format);
            }
            while (i < c.length && this.braceLevel > 0 && c[i] != '\\') {
                if (c[i] == '}') {
                    --this.braceLevel;
                } else if (c[i] == '{') {
                    ++this.braceLevel;
                }
                i = this.convertNonControl(c, i, sb, format);
            }
        }
        return i;
    }

    int convertAccented(char[] c, int pos, String s, StringBuffer sb, char format) {
        pos += s.length();
        switch (format) {
            case 'l': 
            case 't': {
                if ("L O OE AE AA".indexOf(s) != -1) {
                    sb.append(s.toLowerCase());
                    break;
                }
                sb.append(s);
                break;
            }
            case 'u': {
                if ("l o oe ae aa".indexOf(s) != -1) {
                    sb.append(s.toUpperCase());
                    break;
                }
                if ("i j ss".indexOf(s) != -1) {
                    sb.deleteCharAt(sb.length() - 1);
                    sb.append(s.toUpperCase());
                    while (pos < c.length && Character.isWhitespace(c[pos])) {
                        ++pos;
                    }
                    break;
                }
                sb.append(s);
            }
        }
        return pos;
    }

    int convertNonControl(char[] c, int pos, StringBuffer sb, char format) {
        switch (format) {
            case 'l': 
            case 't': {
                sb.append(Character.toLowerCase(c[pos]));
                ++pos;
                break;
            }
            case 'u': {
                sb.append(Character.toUpperCase(c[pos]));
                ++pos;
            }
        }
        return pos;
    }

    int convertChar0(char[] c, int i, StringBuffer sb, char format) {
        switch (format) {
            case 't': {
                if (i == 0) {
                    sb.append(c[i]);
                } else if (this.prevColon && Character.isWhitespace(c[i - 1])) {
                    sb.append(c[i]);
                } else {
                    sb.append(Character.toLowerCase(c[i]));
                }
                if (c[i] == ':') {
                    this.prevColon = true;
                    break;
                }
                if (Character.isWhitespace(c[i])) break;
                this.prevColon = false;
                break;
            }
            case 'l': {
                sb.append(Character.toLowerCase(c[i]));
                break;
            }
            case 'u': {
                sb.append(Character.toUpperCase(c[i]));
            }
        }
        return ++i;
    }

    static String findSpecialChar(char[] c, int pos) {
        if (pos + 1 < c.length) {
            if (c[pos] == 'o' && c[pos + 1] == 'e') {
                return "oe";
            }
            if (c[pos] == 'O' && c[pos + 1] == 'E') {
                return "OE";
            }
            if (c[pos] == 'a' && c[pos + 1] == 'e') {
                return "ae";
            }
            if (c[pos] == 'A' && c[pos + 1] == 'E') {
                return "AE";
            }
            if (c[pos] == 's' && c[pos + 1] == 's') {
                return "ss";
            }
            if (c[pos] == 'A' && c[pos + 1] == 'A') {
                return "AA";
            }
            if (c[pos] == 'a' && c[pos + 1] == 'a') {
                return "aa";
            }
        }
        if (c[pos] == 'i') {
            return String.valueOf(c[pos]);
        }
        if (c[pos] == 'j') {
            return String.valueOf(c[pos]);
        }
        if (c[pos] == 'o') {
            return String.valueOf(c[pos]);
        }
        if (c[pos] == 'O') {
            return String.valueOf(c[pos]);
        }
        if (c[pos] == 'l') {
            return String.valueOf(c[pos]);
        }
        if (c[pos] == 'L') {
            return String.valueOf(c[pos]);
        }
        return null;
    }
}

