/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.autocompleter;

import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.autocompleter.AbstractAutoCompleter;

public class NameFieldAutoCompleter
extends AbstractAutoCompleter {
    private String[] fieldNames;
    private boolean lastNameOnlyAndSeparationBySpace;
    private String prefix = "";
    private boolean autoCompFF;
    private boolean autoCompLF;
    private boolean autoCompFullFirstOnly;
    private boolean autoCompShortFirstOnly;

    protected NameFieldAutoCompleter(String fieldName) {
        this(new String[]{fieldName}, false);
    }

    public NameFieldAutoCompleter(String[] fieldNames, boolean lastNameOnlyAndSeparationBySpace) {
        this.fieldNames = fieldNames;
        this.lastNameOnlyAndSeparationBySpace = lastNameOnlyAndSeparationBySpace;
        if (Globals.prefs.getBoolean("autoCompFF")) {
            this.autoCompFF = true;
            this.autoCompLF = false;
        } else if (Globals.prefs.getBoolean("autoCompLF")) {
            this.autoCompFF = false;
            this.autoCompLF = true;
        } else {
            this.autoCompFF = true;
            this.autoCompLF = true;
        }
        this.autoCompShortFirstOnly = Globals.prefs.get("autoCompFirstNameMode").equals("abbrOnly");
        this.autoCompFullFirstOnly = Globals.prefs.get("autoCompFirstNameMode").equals("fullOnly");
    }

    @Override
    public boolean isSingleUnitField() {
        return !this.lastNameOnlyAndSeparationBySpace;
    }

    @Override
    public void addBibtexEntry(BibtexEntry entry) {
        if (entry != null) {
            for (int i = 0; i < this.fieldNames.length; ++i) {
                String fieldValue = entry.getField(this.fieldNames[i]);
                if (fieldValue == null) continue;
                AuthorList authorList = AuthorList.getAuthorList(fieldValue);
                for (int j = 0; j < authorList.size(); ++j) {
                    AuthorList.Author author = authorList.getAuthor(j);
                    if (this.lastNameOnlyAndSeparationBySpace) {
                        this.addWordToIndex(author.getLastOnly());
                        continue;
                    }
                    if (this.autoCompLF) {
                        if (this.autoCompShortFirstOnly) {
                            this.addWordToIndex(author.getLastFirst(true));
                        } else if (this.autoCompFullFirstOnly) {
                            this.addWordToIndex(author.getLastFirst(false));
                        } else {
                            this.addWordToIndex(author.getLastFirst(true));
                            this.addWordToIndex(author.getLastFirst(false));
                        }
                    }
                    if (!this.autoCompFF) continue;
                    if (this.autoCompShortFirstOnly) {
                        this.addWordToIndex(author.getFirstLast(true));
                        continue;
                    }
                    if (this.autoCompFullFirstOnly) {
                        this.addWordToIndex(author.getFirstLast(false));
                        continue;
                    }
                    this.addWordToIndex(author.getFirstLast(true));
                    this.addWordToIndex(author.getFirstLast(false));
                }
            }
        }
    }

    private String determinePrefixAndReturnRemainder_AND(String str) {
        int index = str.toLowerCase().lastIndexOf(" and ");
        if (index >= 0) {
            this.prefix = str.substring(0, index + 5);
            str = str.substring(index + 5);
        } else {
            this.prefix = "";
        }
        return str;
    }

    private String determinePrefixAndReturnRemainder_SPACE(String str) {
        int index = str.lastIndexOf(" ");
        if (index >= 0) {
            this.prefix = str.substring(0, index + 1);
            str = str.substring(index + 1);
        } else {
            this.prefix = "";
        }
        return str;
    }

    @Override
    public String[] complete(String str) {
        str = this.lastNameOnlyAndSeparationBySpace ? this.determinePrefixAndReturnRemainder_SPACE(str) : this.determinePrefixAndReturnRemainder_AND(str);
        String[] res = super.complete(str);
        return res;
    }

    public String getFieldName() {
        return this.fieldNames[0];
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }
}

