/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Dimension;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class JabRefMain {
    public static String exceptionToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void main(String[] stringArray) {
        String string;
        String string2 = System.getProperty("java.version", null);
        if (string2.compareTo("1.6") < 0) {
            string = "\nWARNING: You are running Java version 1.6 or lower (" + string2 + " to be exact).\n" + "         JabRef needs at least a Java Runtime Environment 1.6 or higher.\n" + "         JabRef should not start properly and output an error message\n" + "         (probably java.lang.UnsupportedClassVersionError ... (Unsupported major.minor version 49.0)\n" + "         See http://jabref.sf.net/faq.php for more information.\n";
            System.out.println(string);
        }
        if ((string = System.getProperty("java.vendor", null)).indexOf("Sun Microsystems") == -1 && string.indexOf("Oracle") == -1) {
            System.out.println("\nWARNING: You are not running a Java version from Oracle (or Sun Microsystems).\n         Your java vendor is: " + string + "\n" + "         If JabRef crashes please consider switching to an Oracle Java Runtime.\n" + "         See http://jabref.sf.net/faq.php for more information.\n");
        }
        try {
            Method method = Class.forName("net.sf.jabref.JabRef").getMethod("main", stringArray.getClass());
            method.invoke(null, new Object[]{stringArray});
        }
        catch (InvocationTargetException invocationTargetException) {
            JComponent jComponent;
            String string3 = "\nERROR while starting or running JabRef:\n\n" + JabRefMain.exceptionToString(invocationTargetException.getCause()) + "\n" + "Please first check if this problem and a solution is already known. Find our...\n" + "  * ...FAQ at http://jabref.sf.net/faq.php and our...\n" + "  * ...user mailing-list at http://sf.net/mailarchive/forum.php?forum_name=jabref-users\n\n" + "If you do not find a solution there, please let us know about the problem by writing a bug report.\n" + "You can find our bug tracker at http://sourceforge.net/p/jabref/bugs/\n\n" + "  * If the bug has already been reported there, please add your comments to the existing bug.\n" + "  * If the bug has not been reported yet, then we need the complete error message given above\n" + "    and a description of what you did before the error occured.\n\n" + "We also need the following information (you can copy and paste all this):\n" + "  * Java Version: " + string2 + "\n" + "  * Java Vendor: " + string + "\n" + "  * Operating System: " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ")\n" + "  * Hardware Architecture: " + System.getProperty("os.arch") + "\n\n" + "We are sorry for the trouble and thanks for reporting problems with JabRef!\n";
            System.out.println(string3);
            JEditorPane jEditorPane = new JEditorPane("text/html", "<html>The following error occurred while running JabRef:<p><font color=\"red\">" + JabRefMain.exceptionToString(invocationTargetException.getCause()).replaceAll("\\n", "<br>") + "</font></p>" + "<p>Please first check if this problem and a solution is already known. Find our...</p>" + "<ul><li>...FAQ at <b>http://jabref.sf.net/faq.php</b> and our..." + "<li>...user mailing-list at <b>http://sf.net/mailarchive/forum.php?forum_name=jabref-users</b></ul>" + "If you do not find a solution there, please let us know about the problem by writing a bug report.<br>" + "You can find our bug tracker at <a href=\"http://sourceforge.net/p/jabref/bugs/\"><b>http://sourceforge.net/p/jabref/bugs/</b></a>.<br>" + "<ul><li>If the bug has already been reported there, please add your comments to the existing bug.<br>" + "<li>If the bug has not been reported yet, then we need the complete error message given above<br>" + "and a description of what you did before the error occured.</ul>" + "We also need the following information (you can copy and paste all this):</p>" + "<ul><li>Java Version: " + string2 + "<li>Java Vendor: " + string + "<li>Operating System: " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ")" + "<li>Hardware Architecture: " + System.getProperty("os.arch") + "</ul>" + "We are sorry for the trouble and thanks for reporting problems with JabRef!</html>");
            jEditorPane.setEditable(false);
            jEditorPane.setOpaque(false);
            jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            if (jEditorPane.getPreferredSize().getHeight() > 700.0) {
                JScrollPane jScrollPane = new JScrollPane(jEditorPane, 20, 31);
                jScrollPane.setBorder(BorderFactory.createEmptyBorder());
                jScrollPane.setPreferredSize(new Dimension((int)jEditorPane.getPreferredSize().getWidth() + 30, 700));
                jComponent = jScrollPane;
            } else {
                jComponent = jEditorPane;
            }
            JOptionPane.showMessageDialog(null, jComponent, "An error occurred while running JabRef", 0);
        }
        catch (SecurityException securityException) {
            System.out.println("ERROR: You are running JabRef in a sandboxed environment that does not allow it to be started.");
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("This error should not happen. Write an email to the JabRef developers and tell them 'NoSuchMethodException in JabRefMain'");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("This error should not happen. Write an email to the JabRef developers and tell them 'ClassNotFoundException in JabRefMain'");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("This error should not happen. Write an email to the JabRef developers and tell them 'IllegalArgumentException in JabRefMain'");
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("This error should not happen. Write an email to the JabRef developers and tell them 'IllegalAccessException in JabRefMain'");
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            String string4 = JabRefMain.exceptionToString(unsupportedClassVersionError) + "\n" + "This means that your Java version (" + string2 + ") is not high enough to run JabRef.\n" + "Please update your Java Runtime Environment to a version 1.6 or higher.\n";
            System.out.println(string4);
            JEditorPane jEditorPane = new JEditorPane("text/html", "<html>You are using Java version " + string2 + ", but JabRef needs version 1.6 or higher." + "<p>Please update your Java Runtime Environment.</p>" + "<p>For more information visit <b>http://jabref.sf.net/faq.php</b>.</p></html>");
            jEditorPane.setEditable(false);
            jEditorPane.setOpaque(false);
            jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            JOptionPane.showMessageDialog(null, jEditorPane, "Insufficient Java Version Installed", 0);
        }
    }
}

