/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.imports.EntryFromFileCreator;
import net.sf.jabref.imports.EntryFromFileCreatorManager;
import net.sf.jabref.imports.UnlinkedFilesCrawler;
import net.sf.jabref.imports.UnlinkedPDFFileFilter;

public class FindUnlinkedFilesDialog
extends JDialog {
    private static final long serialVersionUID = -5778378185253640030L;
    public static final String ACTION_COMMAND = "findUnlinkedFiles";
    public static final String ACTION_TITLE = "Find unlinked Files...";
    public static final String ACTION_ICON = "toggleSearch";
    public static final String ACTION_SHORT_DESCRIPTION = "Searches for unlinked PDF files on the file system";
    private static final String GLOBAL_PREFS_WORKING_DIRECTORY_KEY = "findUnlinkedFilesWD";
    private static final String GLOBAL_PREFS_DIALOG_SIZE_KEY = "findUnlinkedFilesDialogSize";
    protected JabRefFrame frame;
    protected BibtexDatabase database;
    private EntryFromFileCreatorManager creatorManager;
    private UnlinkedFilesCrawler crawler;
    protected File lastSelectedDirectory;
    private TreeModel treeModel;
    protected JPanel panelDirectory;
    protected JPanel panelSearchArea;
    protected JPanel panelFiles;
    protected JPanel panelOptions;
    protected JPanel panelButtons;
    protected JPanel panelEntryTypesSelection;
    protected JPanel panelImportArea;
    protected JPanel mainArea;
    protected JButton buttonBrowse;
    protected JButton buttonScan;
    protected JButton buttonApply;
    protected JButton buttonClose;
    protected JButton buttonOptionSelectAll;
    protected JButton buttonOptionUnselectAll;
    protected JButton buttonOptionExpandAll;
    protected JButton buttonOptionCollapseAll;
    protected JCheckBox checkboxCreateKeywords;
    protected JTextField textfieldDirectoryPath;
    protected JLabel labelDirectoryDescription;
    protected JLabel labelFileTypesDescription;
    protected JLabel labelFilesDescription;
    protected JLabel labelEntryTypeDescription;
    protected JLabel labelSearchingDirectoryInfo;
    protected JLabel labelImportingInfo;
    protected JTree tree;
    protected JScrollPane scrollpaneTree;
    protected JComboBox comboBoxFileTypeSelection;
    protected JComboBox comboBoxEntryTypeSelection;
    private JProgressBar progressBarSearching;
    private JProgressBar progressBarImporting;
    private JFileChooser fileChooser;
    private MouseListener treeMouseListener;
    private Action actionSelectAll;
    private Action actionUnselectAll;
    private Action actionExpandTree;
    private Action actionCollapseTree;
    private ActionListener actionListenerImportEntrys;
    private ComponentListener dialogPositionListener;
    private int[] threadState = new int[]{1};
    private boolean checkBoxWhyIsThereNoGetSelectedStupidSwing = false;

    private FindUnlinkedFilesDialog() {
    }

    public FindUnlinkedFilesDialog(Frame owner, JabRefFrame frame, BasePanel panel) {
        super(owner, Globals.lang("Find unlinked files"), true);
        this.frame = frame;
        this.restoreSizeOfDialog();
        this.database = panel.getDatabase();
        this.creatorManager = new EntryFromFileCreatorManager();
        this.crawler = new UnlinkedFilesCrawler(this.database);
        this.lastSelectedDirectory = this.loadLastSelectedDirectory();
        this.initialize();
        this.buttonApply.setEnabled(false);
    }

    @Override
    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindUnlinkedFilesDialog.this.setVisible(false);
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    private void storeSizeOfDialog() {
        Dimension dim = this.getSize();
        String store = dim.width + ";" + dim.height;
        Globals.prefs.put(GLOBAL_PREFS_DIALOG_SIZE_KEY, store);
    }

    private void restoreSizeOfDialog() {
        String store = Globals.prefs.get(GLOBAL_PREFS_DIALOG_SIZE_KEY);
        Dimension dimension = null;
        if (store != null) {
            try {
                String[] dim = store.split(";");
                dimension = new Dimension(new Integer(dim[0]), new Integer(dim[1]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (dimension != null) {
            this.setPreferredSize(dimension);
        }
    }

    protected void initialize() {
        this.initializeActions();
        this.initComponents();
        this.createTree();
        this.createFileTypesCombobox();
        this.createEntryTypesCombobox();
        this.initLayout();
        this.setupActions();
        this.pack();
    }

    protected void initializeActions() {
        this.actionSelectAll = new AbstractAction(Globals.lang("Select All")){
            private static final long serialVersionUID = 9153126361571985383L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckableTreeNode rootNode = (CheckableTreeNode)FindUnlinkedFilesDialog.this.tree.getModel().getRoot();
                rootNode.setSelected(true);
                FindUnlinkedFilesDialog.this.tree.invalidate();
                FindUnlinkedFilesDialog.this.tree.repaint();
            }
        };
        this.actionUnselectAll = new AbstractAction(Globals.lang("Unselect All")){
            private static final long serialVersionUID = -9012913268030356450L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckableTreeNode rootNode = (CheckableTreeNode)FindUnlinkedFilesDialog.this.tree.getModel().getRoot();
                rootNode.setSelected(false);
                FindUnlinkedFilesDialog.this.tree.invalidate();
                FindUnlinkedFilesDialog.this.tree.repaint();
            }
        };
        this.actionExpandTree = new AbstractAction(Globals.lang("Expand All")){
            private static final long serialVersionUID = -4794088095435302433L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckableTreeNode rootNode = (CheckableTreeNode)FindUnlinkedFilesDialog.this.tree.getModel().getRoot();
                FindUnlinkedFilesDialog.this.expandTree(FindUnlinkedFilesDialog.this.tree, new TreePath(rootNode), true);
            }
        };
        this.actionCollapseTree = new AbstractAction(Globals.lang("Collapse All")){
            private static final long serialVersionUID = 6007246730370326456L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckableTreeNode rootNode = (CheckableTreeNode)FindUnlinkedFilesDialog.this.tree.getModel().getRoot();
                FindUnlinkedFilesDialog.this.expandTree(FindUnlinkedFilesDialog.this.tree, new TreePath(rootNode), false);
            }
        };
        this.dialogPositionListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FindUnlinkedFilesDialog.this.storeSizeOfDialog();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                FindUnlinkedFilesDialog.this.storeSizeOfDialog();
            }
        };
    }

    private void storeLastSelectedDirectory(File lastSelectedDirectory) {
        this.lastSelectedDirectory = lastSelectedDirectory;
        if (lastSelectedDirectory != null) {
            Globals.prefs.put(GLOBAL_PREFS_WORKING_DIRECTORY_KEY, lastSelectedDirectory.getAbsolutePath());
        }
    }

    private File loadLastSelectedDirectory() {
        String workingDirectory = Globals.prefs.get(GLOBAL_PREFS_WORKING_DIRECTORY_KEY);
        if (workingDirectory == null) {
            workingDirectory = Globals.prefs.get("workingDirectory");
        }
        this.lastSelectedDirectory = new File(workingDirectory);
        if (this.lastSelectedDirectory.isFile()) {
            this.lastSelectedDirectory = this.lastSelectedDirectory.getParentFile();
        }
        return this.lastSelectedDirectory;
    }

    private File chooseDirectory() {
        String path;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setAutoscrolls(true);
            this.fileChooser.setDialogTitle(Globals.lang("Select Directory"));
            this.fileChooser.setApproveButtonText(Globals.lang("Choose Directory"));
            this.fileChooser.setApproveButtonToolTipText(Globals.lang("Use the selected directory to start with the search."));
            this.fileChooser.setFileSelectionMode(1);
        }
        if ((path = this.textfieldDirectoryPath.getText()) == null || path.equals("")) {
            this.fileChooser.setCurrentDirectory(this.lastSelectedDirectory);
        } else {
            this.fileChooser.setCurrentDirectory(new File(path));
        }
        int result = this.fileChooser.showOpenDialog(this.frame);
        if (result == 1) {
            return null;
        }
        File selectedDirectory = this.fileChooser.getSelectedFile();
        String filepath = "";
        if (selectedDirectory != null) {
            filepath = selectedDirectory.getAbsolutePath();
        }
        this.textfieldDirectoryPath.setText(filepath);
        return selectedDirectory;
    }

    private void disOrEnableDialog(boolean enable) {
        if (enable) {
            this.tree.addMouseListener(this.treeMouseListener);
        } else {
            this.tree.removeMouseListener(this.treeMouseListener);
        }
        this.disOrEnableAllElements(this, enable);
    }

    private void disOrEnableAllElements(Container startContainer, boolean enable) {
        Component[] children = startContainer.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Component child = children[i];
            if (child instanceof Container) {
                this.disOrEnableAllElements((Container)child, enable);
            }
            child.setEnabled(enable);
        }
    }

    private void expandTree(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreePath path = parent.pathByAddingChild(e.nextElement());
                this.expandTree(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    protected void startSearch() {
        final File directory = new File(this.textfieldDirectoryPath.getText());
        if (!directory.exists() || !directory.isDirectory()) {
            this.textfieldDirectoryPath.setText("");
            return;
        }
        this.storeLastSelectedDirectory(directory);
        this.progressBarSearching.setMinimumSize(new Dimension(this.buttonScan.getSize().width, this.progressBarSearching.getMinimumSize().height));
        this.progressBarSearching.setVisible(true);
        this.progressBarSearching.setString("");
        this.labelSearchingDirectoryInfo.setVisible(true);
        this.buttonScan.setVisible(false);
        this.disOrEnableDialog(false);
        this.labelSearchingDirectoryInfo.setEnabled(true);
        final FileFilter selectedFileFilter = (FileFilter)this.comboBoxFileTypeSelection.getSelectedItem();
        this.threadState = new int[]{1};
        new Thread(new Runnable(){

            @Override
            public void run() {
                UnlinkedPDFFileFilter ff = new UnlinkedPDFFileFilter(selectedFileFilter, FindUnlinkedFilesDialog.this.database);
                CheckableTreeNode rootNode = FindUnlinkedFilesDialog.this.crawler.searchDirectory(directory, ff, FindUnlinkedFilesDialog.this.threadState, new ChangeListener(){
                    int counter = 0;

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        FindUnlinkedFilesDialog.this.progressBarSearching.setString(++this.counter + " files found");
                    }
                });
                FindUnlinkedFilesDialog.this.searchFinishedHandler(rootNode);
            }
        }).start();
    }

    protected void startImport() {
        if (this.treeModel == null) {
            return;
        }
        this.setDefaultCloseOperation(0);
        CheckableTreeNode root = (CheckableTreeNode)this.treeModel.getRoot();
        final List<File> fileList = this.getFileListFromNode(root);
        if (fileList == null || fileList.isEmpty()) {
            return;
        }
        this.progressBarImporting.setVisible(true);
        this.labelImportingInfo.setVisible(true);
        this.buttonApply.setVisible(false);
        this.buttonClose.setVisible(false);
        this.disOrEnableDialog(false);
        this.labelImportingInfo.setEnabled(true);
        this.progressBarImporting.setMinimum(0);
        this.progressBarImporting.setMaximum(fileList.size());
        this.progressBarImporting.setValue(0);
        this.progressBarImporting.setString("");
        final BibtexEntryType entryType = ((BibtexEntryTypeWrapper)this.comboBoxEntryTypeSelection.getSelectedItem()).entryType;
        this.threadState = new int[]{1};
        new Thread(new Runnable(){

            @Override
            public void run() {
                LinkedList<String> errors = new LinkedList<String>();
                int count = FindUnlinkedFilesDialog.this.creatorManager.addEntrysFromFiles(fileList, FindUnlinkedFilesDialog.this.database, FindUnlinkedFilesDialog.this.frame.basePanel(), entryType, FindUnlinkedFilesDialog.this.checkBoxWhyIsThereNoGetSelectedStupidSwing, new ChangeListener(){
                    int counter = 0;

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        FindUnlinkedFilesDialog.this.progressBarImporting.setValue(++this.counter);
                        FindUnlinkedFilesDialog.this.progressBarImporting.setString(this.counter + " of " + FindUnlinkedFilesDialog.this.progressBarImporting.getMaximum());
                    }
                }, errors);
                FindUnlinkedFilesDialog.this.importFinishedHandler(count, errors);
            }
        }).start();
    }

    protected void importFinishedHandler(int count, List<String> errors) {
        if (errors != null && errors.size() > 0) {
            StringBuffer warningInfo = new StringBuffer();
            warningInfo.append("The import finished with warnings:\n");
            warningInfo.append("There ");
            warningInfo.append(errors.size() > 1 ? "were " : "was ");
            warningInfo.append(errors.size());
            warningInfo.append(errors.size() > 1 ? " files" : " file");
            warningInfo.append(errors.size() > 1 ? " which" : " that");
            warningInfo.append(" could not be imported.");
            JOptionPane.showMessageDialog(this, warningInfo.toString(), Globals.lang("Warning"), 2);
        }
        this.progressBarImporting.setVisible(false);
        this.labelImportingInfo.setVisible(false);
        this.buttonApply.setVisible(true);
        this.buttonClose.setVisible(true);
        this.disOrEnableDialog(true);
        this.setDefaultCloseOperation(2);
        this.frame.basePanel().markBaseChanged();
    }

    protected void searchFinishedHandler(CheckableTreeNode rootNode) {
        this.treeModel = new DefaultTreeModel(rootNode);
        this.tree.setModel(this.treeModel);
        this.tree.setRootVisible(rootNode.getChildCount() > 0);
        this.tree.invalidate();
        this.tree.repaint();
        this.progressBarSearching.setVisible(false);
        this.labelSearchingDirectoryInfo.setVisible(false);
        this.buttonScan.setVisible(true);
        this.actionSelectAll.actionPerformed(null);
        this.disOrEnableDialog(true);
        this.buttonApply.setEnabled(true);
    }

    private void setupActions() {
        this.buttonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File selectedDirectory = FindUnlinkedFilesDialog.this.chooseDirectory();
                FindUnlinkedFilesDialog.this.storeLastSelectedDirectory(selectedDirectory);
            }
        });
        this.buttonScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindUnlinkedFilesDialog.this.startSearch();
            }
        });
        this.actionListenerImportEntrys = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindUnlinkedFilesDialog.this.startImport();
            }
        };
        this.buttonApply.addActionListener(this.actionListenerImportEntrys);
        this.buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindUnlinkedFilesDialog.this.dispose();
            }
        });
    }

    private List<File> getFileListFromNode(CheckableTreeNode node) {
        ArrayList<File> filesList = new ArrayList<File>();
        Enumeration<TreeNode> childs = node.depthFirstEnumeration();
        ArrayList<CheckableTreeNode> nodesToRemove = new ArrayList<CheckableTreeNode>();
        while (childs.hasMoreElements()) {
            File nodeFile;
            CheckableTreeNode child = (CheckableTreeNode)childs.nextElement();
            if (!child.isLeaf() || !child.getSelected() || (nodeFile = ((FileNodeWrapper)child.getUserObject()).file) == null || !nodeFile.isFile()) continue;
            filesList.add(nodeFile);
            nodesToRemove.add(child);
        }
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        for (CheckableTreeNode nodeToRemove : nodesToRemove) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)nodeToRemove.getParent();
            model.removeNodeFromParent(nodeToRemove);
            while (parent != null && parent.isLeaf()) {
                DefaultMutableTreeNode pp = (DefaultMutableTreeNode)parent.getParent();
                if (pp != null) {
                    model.removeNodeFromParent(parent);
                }
                parent = pp;
            }
        }
        this.tree.invalidate();
        this.tree.repaint();
        return filesList;
    }

    private void initComponents() {
        this.addComponentListener(this.dialogPositionListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ((FindUnlinkedFilesDialog)FindUnlinkedFilesDialog.this).threadState[0] = 0;
            }
        });
        this.panelDirectory = new JPanel();
        this.panelSearchArea = new JPanel();
        this.panelFiles = new JPanel();
        this.panelOptions = new JPanel();
        this.panelEntryTypesSelection = new JPanel();
        this.panelButtons = new JPanel();
        this.panelImportArea = new JPanel();
        this.mainArea = new JPanel();
        this.buttonBrowse = new JButton(Globals.lang("Browse..."));
        this.buttonBrowse.setMnemonic('B');
        this.buttonBrowse.setToolTipText(Globals.lang("Opens the file browser."));
        this.buttonScan = new JButton(Globals.lang("Scan directory"));
        this.buttonScan.setMnemonic('S');
        this.buttonScan.setToolTipText(Globals.lang("Searches the selected directory for unlinked files."));
        this.buttonApply = new JButton(Globals.lang("Apply"));
        this.buttonApply.setMnemonic('I');
        this.buttonApply.setToolTipText(Globals.lang("Starts the import of bibtex entries."));
        this.buttonClose = new JButton(Globals.lang("Close"));
        this.buttonClose.setToolTipText(Globals.lang("Leave this dialog."));
        this.buttonClose.setMnemonic('C');
        this.buttonOptionSelectAll = new JButton();
        this.buttonOptionSelectAll.setMnemonic('A');
        this.buttonOptionSelectAll.setAction(this.actionSelectAll);
        this.buttonOptionUnselectAll = new JButton();
        this.buttonOptionUnselectAll.setMnemonic('U');
        this.buttonOptionUnselectAll.setAction(this.actionUnselectAll);
        this.buttonOptionExpandAll = new JButton();
        this.buttonOptionExpandAll.setMnemonic('E');
        this.buttonOptionExpandAll.setAction(this.actionExpandTree);
        this.buttonOptionCollapseAll = new JButton();
        this.buttonOptionCollapseAll.setMnemonic('L');
        this.buttonOptionCollapseAll.setAction(this.actionCollapseTree);
        this.checkboxCreateKeywords = new JCheckBox(Globals.lang("Create directory based keywords"));
        this.checkboxCreateKeywords.setToolTipText(Globals.lang("Creates keywords in created entrys with directory pathnames"));
        this.checkboxCreateKeywords.setSelected(this.checkBoxWhyIsThereNoGetSelectedStupidSwing);
        this.checkboxCreateKeywords.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FindUnlinkedFilesDialog.this.checkBoxWhyIsThereNoGetSelectedStupidSwing = !FindUnlinkedFilesDialog.this.checkBoxWhyIsThereNoGetSelectedStupidSwing;
            }
        });
        this.textfieldDirectoryPath = new JTextField();
        this.textfieldDirectoryPath.setText(this.lastSelectedDirectory == null ? "" : this.lastSelectedDirectory.getAbsolutePath());
        this.labelDirectoryDescription = new JLabel(Globals.lang("Select a directory where the search shall start."));
        this.labelFileTypesDescription = new JLabel(Globals.lang("Select file type:"));
        this.labelFilesDescription = new JLabel(Globals.lang("These files are not linked in the active database."));
        this.labelEntryTypeDescription = new JLabel(Globals.lang("Entry type to be created:"));
        this.labelSearchingDirectoryInfo = new JLabel(Globals.lang("Searching file system..."));
        this.labelSearchingDirectoryInfo.setHorizontalAlignment(0);
        this.labelSearchingDirectoryInfo.setVisible(false);
        this.labelImportingInfo = new JLabel(Globals.lang("Importing into Database..."));
        this.labelImportingInfo.setHorizontalAlignment(0);
        this.labelImportingInfo.setVisible(false);
        this.tree = new JTree();
        this.scrollpaneTree = new JScrollPane(this.tree);
        this.scrollpaneTree.setWheelScrollingEnabled(true);
        this.progressBarSearching = new JProgressBar();
        this.progressBarSearching.setIndeterminate(true);
        this.progressBarSearching.setVisible(false);
        this.progressBarSearching.setStringPainted(true);
        this.progressBarImporting = new JProgressBar();
        this.progressBarImporting.setIndeterminate(false);
        this.progressBarImporting.setVisible(false);
        this.progressBarImporting.setStringPainted(true);
    }

    private void initLayout() {
        GridBagLayout gbl = new GridBagLayout();
        this.panelDirectory.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Select directory")));
        this.panelFiles.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Select files")));
        this.panelEntryTypesSelection.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Bibtex entry creation")));
        Insets basicInsets = new Insets(6, 6, 6, 6);
        Insets smallInsets = new Insets(3, 2, 3, 1);
        Insets noInsets = new Insets(0, 0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelSearchArea, this.buttonScan, 2, 13, noInsets, 0, 1, 1, 1, 1.0, 1.0, 40, 10);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelSearchArea, this.labelSearchingDirectoryInfo, 2, 13, noInsets, 0, 2, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelSearchArea, this.progressBarSearching, 2, 13, noInsets, 0, 3, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelDirectory, this.labelDirectoryDescription, null, 17, new Insets(6, 6, 0, 6), 0, 0, 3, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelDirectory, this.textfieldDirectoryPath, 2, null, basicInsets, 0, 1, 2, 1, 1.0, 1.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelDirectory, this.buttonBrowse, 2, 13, basicInsets, 2, 1, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelDirectory, this.labelFileTypesDescription, 0, 17, new Insets(18, 6, 18, 3), 0, 3, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelDirectory, this.comboBoxFileTypeSelection, 2, 17, new Insets(18, 3, 18, 6), 1, 3, 1, 1, 1.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelDirectory, this.panelSearchArea, 2, 13, new Insets(18, 6, 18, 6), 2, 3, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelFiles, this.labelFilesDescription, 2, 17, new Insets(6, 6, 0, 6), 0, 0, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelFiles, this.scrollpaneTree, 1, 10, basicInsets, 0, 1, 1, 1, 1.0, 1.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelFiles, this.panelOptions, 0, 12, basicInsets, 1, 1, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelOptions, this.buttonOptionSelectAll, 2, 11, noInsets, 0, 0, 1, 1, 1.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelOptions, this.buttonOptionUnselectAll, 2, 11, noInsets, 0, 1, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelOptions, this.buttonOptionExpandAll, 2, 11, new Insets(6, 0, 0, 0), 0, 2, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelOptions, this.buttonOptionCollapseAll, 2, 11, noInsets, 0, 3, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelEntryTypesSelection, this.labelEntryTypeDescription, 0, 17, basicInsets, 0, 0, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelEntryTypesSelection, this.comboBoxEntryTypeSelection, 0, 17, basicInsets, 1, 0, 1, 1, 1.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelEntryTypesSelection, this.checkboxCreateKeywords, 2, 17, basicInsets, 0, 1, 2, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelImportArea, this.labelImportingInfo, 2, 10, new Insets(6, 6, 0, 6), 0, 1, 1, 1, 1.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelImportArea, this.progressBarImporting, 2, 10, new Insets(0, 6, 6, 6), 0, 2, 1, 1, 1.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.panelButtons, this.panelImportArea, 0, 13, smallInsets, 1, 0, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.getContentPane(), this.panelDirectory, 2, 10, basicInsets, 0, 0, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.getContentPane(), this.panelFiles, 1, 18, new Insets(12, 6, 2, 2), 0, 1, 1, 1, 1.0, 1.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.getContentPane(), this.panelEntryTypesSelection, 2, 16, new Insets(12, 6, 2, 2), 0, 2, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gbl, this.getContentPane(), this.panelButtons, 2, 10, new Insets(10, 6, 10, 6), 0, 3, 1, 1, 0.0, 0.0, 0, 0);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)this.buttonApply);
        bb.addButton((JComponent)this.buttonClose);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panelImportArea.add((Component)bb.getPanel(), 0);
        this.pack();
    }

    private static final void addComponent(GridBagLayout layout, Container container, Component component, Integer fill, Integer anchor, Insets insets, int gridX, int gridY, int width, int height, double weightX, double weightY, int ipadX, int ipadY) {
        container.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridX;
        constraints.gridy = gridY;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        constraints.weightx = weightX;
        constraints.weighty = weightY;
        constraints.ipadx = ipadX;
        constraints.ipady = ipadY;
        if (fill != null) {
            constraints.fill = fill;
        }
        if (insets != null) {
            constraints.insets = insets;
        }
        if (anchor != null) {
            constraints.anchor = anchor;
        }
        layout.setConstraints(component, constraints);
        container.add(component);
    }

    private void createTree() {
        this.treeMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int y;
                int x = e.getX();
                int row = FindUnlinkedFilesDialog.this.tree.getRowForLocation(x, y = e.getY());
                TreePath path = FindUnlinkedFilesDialog.this.tree.getPathForRow(row);
                if (path != null) {
                    CheckableTreeNode node = (CheckableTreeNode)path.getLastPathComponent();
                    if (e.getClickCount() == 2) {
                        Object userObject = node.getUserObject();
                        if (userObject instanceof FileNodeWrapper && node.isLeaf()) {
                            FileNodeWrapper fnw = (FileNodeWrapper)userObject;
                            try {
                                Util.openExternalViewer(JabRef.jrf.basePanel().metaData(), fnw.file.getAbsolutePath(), "pdf");
                            }
                            catch (IOException e1) {
                                Globals.logger("Error opening file");
                            }
                        }
                    } else {
                        node.check();
                        FindUnlinkedFilesDialog.this.tree.invalidate();
                        FindUnlinkedFilesDialog.this.tree.repaint();
                    }
                }
            }
        };
        CheckableTreeNode startNode = new CheckableTreeNode("ROOT");
        DefaultTreeModel model = new DefaultTreeModel(startNode);
        this.tree.setModel(model);
        this.tree.setRootVisible(false);
        CheckboxTreeCellRenderer renderer = new CheckboxTreeCellRenderer();
        this.tree.setCellRenderer(renderer);
        this.tree.addMouseListener(this.treeMouseListener);
    }

    private void createFileTypesCombobox() {
        List<FileFilter> fileFilterList = this.creatorManager.getFileFilterList();
        Vector<FileFilter> vector = new Vector<FileFilter>();
        for (FileFilter fileFilter : fileFilterList) {
            vector.add(fileFilter);
        }
        this.comboBoxFileTypeSelection = new JComboBox(vector);
        this.comboBoxFileTypeSelection.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 8503499454763947465L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                EntryFromFileCreator creator;
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof EntryFromFileCreator && (creator = (EntryFromFileCreator)value).getExternalFileType() != null) {
                    label.setIcon(creator.getExternalFileType().getIcon());
                }
                return label;
            }
        });
    }

    private void createEntryTypesCombobox() {
        TreeMap<String, BibtexEntryType> entryTypes = BibtexEntryType.ALL_TYPES;
        Iterator<BibtexEntryType> iterator = entryTypes.values().iterator();
        Vector<BibtexEntryTypeWrapper> list = new Vector<BibtexEntryTypeWrapper>();
        list.add(new BibtexEntryTypeWrapper(null));
        while (iterator.hasNext()) {
            list.add(new BibtexEntryTypeWrapper(iterator.next()));
        }
        this.comboBoxEntryTypeSelection = new JComboBox(list);
    }

    public static class FileNodeWrapper {
        public final File file;
        public final int fileCount;

        public FileNodeWrapper(File aFile) {
            this(aFile, 0);
        }

        public FileNodeWrapper(File aDirectory, int fileCount) {
            this.file = aDirectory;
            this.fileCount = fileCount;
        }

        public String toString() {
            return this.file.getName();
        }
    }

    private static class CheckboxTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 3737245079578074387L;
        protected FileSystemView fsv = FileSystemView.getFileSystemView();

        private CheckboxTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component nodeComponent = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            CheckableTreeNode node = (CheckableTreeNode)value;
            FileNodeWrapper userObject = (FileNodeWrapper)node.getUserObject();
            JPanel newPanel = new JPanel();
            JCheckBox checkbox = node.getCheckbox();
            checkbox.setSelected(node.getSelected());
            try {
                this.setIcon(this.fsv.getSystemIcon(userObject.file));
            }
            catch (Exception e) {
                // empty catch block
            }
            newPanel.setBackground(nodeComponent.getBackground());
            checkbox.setBackground(nodeComponent.getBackground());
            GridBagLayout gbl = new GridBagLayout();
            FindUnlinkedFilesDialog.addComponent(gbl, newPanel, checkbox, null, null, null, 0, 0, 1, 1, 0.0, 0.0, 0, 0);
            FindUnlinkedFilesDialog.addComponent(gbl, newPanel, nodeComponent, 2, null, new Insets(1, 2, 0, 0), 1, 0, 1, 1, 1.0, 0.0, 0, 0);
            if (userObject.fileCount > 0) {
                JLabel label = new JLabel("(" + userObject.fileCount + " file" + (userObject.fileCount > 1 ? "s" : "") + ")");
                FindUnlinkedFilesDialog.addComponent(gbl, newPanel, label, null, null, new Insets(1, 2, 0, 0), 2, 0, 1, 1, 0.0, 0.0, 0, 0);
            }
            return newPanel;
        }
    }

    public static class CheckableTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -1131241777605570737L;
        private boolean isSelected;
        private JCheckBox checkbox = new JCheckBox();

        public CheckableTreeNode(Object userObject) {
            super(userObject);
        }

        public JCheckBox getCheckbox() {
            return this.checkbox;
        }

        public void setCheckbox(JCheckBox checkbox) {
            this.checkbox = checkbox;
        }

        public void check() {
            this.setSelected(!this.isSelected);
        }

        public void setSelected(boolean bSelected) {
            this.isSelected = bSelected;
            Enumeration<TreeNode> children = this.children();
            while (children.hasMoreElements()) {
                CheckableTreeNode child = (CheckableTreeNode)children.nextElement();
                child.setSelected(bSelected);
            }
        }

        public boolean getSelected() {
            return this.isSelected;
        }
    }

    private static class BibtexEntryTypeWrapper {
        final BibtexEntryType entryType;

        BibtexEntryTypeWrapper(BibtexEntryType bibtexType) {
            this.entryType = bibtexType;
        }

        public String toString() {
            if (this.entryType == null) {
                return Globals.lang("<No selection>");
            }
            return this.entryType.getName();
        }
    }
}

