/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import net.sf.jabref.ClipBoardManager;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.util.CaseChangeMenu;
import net.sf.jabref.util.NameListNormalizer;

public class FieldTextMenu
implements MouseListener {
    private FieldEditor myFieldName;
    private JPopupMenu inputMenu = new JPopupMenu();
    private CopyAction copyAct = new CopyAction();
    private PasteAction pasteAct = new PasteAction();

    public FieldTextMenu(FieldEditor fieldComponent) {
        this.myFieldName = fieldComponent;
        this.inputMenu.add(this.pasteAct);
        this.inputMenu.add(this.copyAct);
        this.inputMenu.addSeparator();
        this.inputMenu.add(new ReplaceAction());
        if (this.myFieldName.getTextComponent() instanceof JTextComponent) {
            this.inputMenu.add(new CaseChangeMenu((JTextComponent)this.myFieldName.getTextComponent()));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger() && this.myFieldName != null) {
            this.myFieldName.requestFocus();
            String txt = this.myFieldName.getSelectedText();
            boolean cStat = false;
            if (txt != null && txt.length() > 0) {
                cStat = true;
            }
            this.copyAct.setEnabled(cStat);
            this.inputMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class ReplaceAction
    extends BasicAction {
        public ReplaceAction() {
            super("Normalize to BibTeX name format");
            this.putValue("ShortDescription", Globals.lang("If possible, normalize this list of names to conform to standard BibTeX name formatting"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (FieldTextMenu.this.myFieldName.getText().equals("")) {
                return;
            }
            String input = FieldTextMenu.this.myFieldName.getText();
            FieldTextMenu.this.myFieldName.setText(NameListNormalizer.normalizeAuthorList(input));
        }
    }

    class CopyAction
    extends BasicAction {
        public CopyAction() {
            super("Copy to clipboard", "Copy to clipboard", GUIGlobals.getIconUrl("copy"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String data;
                if (FieldTextMenu.this.myFieldName != null && (data = FieldTextMenu.this.myFieldName.getSelectedText()) != null && data.length() > 0) {
                    ClipBoardManager.clipBoard.setClipboardContents(data);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class PasteAction
    extends BasicAction {
        public PasteAction() {
            super("Paste from clipboard", "Paste from clipboard", GUIGlobals.getIconUrl("paste"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String data = ClipBoardManager.clipBoard.getClipboardContents();
                if (data != null && data.length() > 0 && FieldTextMenu.this.myFieldName != null) {
                    FieldTextMenu.this.myFieldName.paste(data);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    abstract class BasicAction
    extends AbstractAction {
        public BasicAction(String text, String description, URL icon) {
            super(Globals.lang(text), new ImageIcon(icon));
            this.putValue("ShortDescription", Globals.lang(description));
        }

        public BasicAction(String text, String description, URL icon, KeyStroke key) {
            super(Globals.lang(text), new ImageIcon(icon));
            this.putValue("AcceleratorKey", key);
            this.putValue("ShortDescription", Globals.lang(description));
        }

        public BasicAction(String text) {
            super(Globals.lang(text));
        }

        public BasicAction(String text, KeyStroke key) {
            super(Globals.lang(text));
            this.putValue("AcceleratorKey", key);
        }

        @Override
        public abstract void actionPerformed(ActionEvent var1);
    }
}

