/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.PrintWriter;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import mediathek.controller.Log;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimedTextMarkupLanguageParser {
    private final SimpleDateFormat ttmlFormat = new SimpleDateFormat("HH:mm:ss.SS");
    private final SimpleDateFormat srtFormat = new SimpleDateFormat("HH:mm:ss,SS");
    private final Map<String, String> colorMap = new Hashtable<String, String>();
    private final List<Subtitle> subtitleList = new ArrayList<Subtitle>();
    private Document doc = null;

    private void buildColorMap() {
        NodeList styleData = this.doc.getElementsByTagName("tt:style");
        for (int i = 0; i < styleData.getLength(); ++i) {
            Node subnode = styleData.item(i);
            if (!subnode.hasAttributes()) continue;
            NamedNodeMap attrMap = subnode.getAttributes();
            Node idNode = attrMap.getNamedItem("xml:id");
            Node colorNode = attrMap.getNamedItem("tts:color");
            if (idNode == null || colorNode == null) continue;
            this.colorMap.put(idNode.getNodeValue(), colorNode.getNodeValue());
        }
    }

    private void buildFilmList() throws Exception {
        NodeList subtitleData = this.doc.getElementsByTagName("tt:p");
        for (int i = 0; i < subtitleData.getLength(); ++i) {
            Subtitle subtitle = new Subtitle();
            Node subnode = subtitleData.item(i);
            if (subnode.hasAttributes()) {
                NamedNodeMap attrMap = subnode.getAttributes();
                Node beginNode = attrMap.getNamedItem("begin");
                Node endNode = attrMap.getNamedItem("end");
                if (beginNode != null && endNode != null) {
                    subtitle.begin = this.ttmlFormat.parse(beginNode.getNodeValue());
                    if (subtitle.begin.getHours() >= 10) {
                        subtitle.begin.setHours(subtitle.begin.getHours() - 10);
                    }
                    subtitle.end = this.ttmlFormat.parse(endNode.getNodeValue());
                    if (subtitle.end.getHours() >= 10) {
                        subtitle.end.setHours(subtitle.end.getHours() - 10);
                    }
                }
            }
            NodeList childNodes = subnode.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node node = childNodes.item(j);
                if (!node.getNodeName().equalsIgnoreCase("tt:span")) continue;
                NamedNodeMap attrMap = node.getAttributes();
                Node styleNode = attrMap.getNamedItem("style");
                StyledString textContent = new StyledString();
                textContent.setText(node.getTextContent());
                textContent.setColor(this.colorMap.get(styleNode.getNodeValue()));
                subtitle.listOfStrings.add(textContent);
            }
            this.subtitleList.add(subtitle);
        }
    }

    public boolean parse(Path ttmlFilePath) {
        boolean ret = false;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.doc = db.parse(ttmlFilePath.toFile());
            NodeList metaData = this.doc.getElementsByTagName("ebuttm:documentEbuttVersion");
            if (metaData != null) {
                Node versionNode = metaData.item(0);
                if (!versionNode.getTextContent().equalsIgnoreCase("v1.0")) {
                    throw new Exception("Unknown TTML file version");
                }
            } else {
                throw new Exception("Unknown File Format");
            }
            this.buildColorMap();
            this.buildFilmList();
            ret = true;
        }
        catch (Exception ex) {
            Log.fehlerMeldung(912036478, ex, "File: " + ttmlFilePath);
            ret = false;
        }
        return ret;
    }

    public void toSrt(Path srtFile) {
        try (PrintWriter writer = new PrintWriter(srtFile.toFile());){
            long counter = 1L;
            for (Subtitle title : this.subtitleList) {
                writer.println(counter);
                writer.println(this.srtFormat.format(title.begin) + " --> " + this.srtFormat.format(title.end));
                for (StyledString entry : title.listOfStrings) {
                    if (!entry.color.isEmpty()) {
                        writer.print("<font color=\"" + entry.color + "\">");
                    }
                    writer.print(entry.text);
                    if (!entry.color.isEmpty()) {
                        writer.print("</font>");
                    }
                    writer.println();
                }
                writer.println("");
                ++counter;
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(201036470, ex, "File: " + srtFile);
        }
    }

    public void cleanup() {
        this.colorMap.clear();
        this.subtitleList.clear();
    }

    private class Subtitle {
        public Date begin;
        public Date end;
        public List<StyledString> listOfStrings = new ArrayList<StyledString>();

        private Subtitle() {
        }
    }

    private class StyledString {
        private String text;
        private String color;

        private StyledString() {
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }
    }
}

