/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.net.URISyntaxException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import mediathek.daten.Daten;
import mediathek.gui.dialog.MVFilmInfo;
import mediathek.res.GetIcon;
import mediathek.tool.BeobMausUrl;
import mediathek.tool.EscBeenden;
import mediathek.tool.UrlHyperlinkAction;
import msearch.daten.DatenFilm;
import org.jdesktop.swingx.JXHyperlink;

public class MVFilmInformationLinux
extends JDialog
implements MVFilmInfo {
    private JXHyperlink lblUrlThemaField;
    private JXHyperlink lblUrlSubtitle;
    private JTextArea textAreaBeschreibung;
    private JLabel jLabelFilmNeu;
    private final JLabel[] labelArrNames = new JLabel[26];
    private final JTextField[] txtArrCont = new JTextField[26];
    private DatenFilm aktFilm = new DatenFilm();
    private final JFrame parent;
    private static ImageIcon ja_sw_16 = null;
    private JPanel jPanelExtra;

    public MVFilmInformationLinux(JFrame owner, JTabbedPane tabbedPane, Daten ddaten) {
        super((Frame)owner, false);
        this.initComponents();
        this.parent = owner;
        this.setTitle("Filminformation");
        ja_sw_16 = GetIcon.getProgramIcon("ja_sw_16.png");
        for (int i = 0; i < 26; ++i) {
            this.labelArrNames[i] = new JLabel(DatenFilm.COLUMN_NAMES[i] + ":");
            this.labelArrNames[i].setHorizontalAlignment(4);
            this.labelArrNames[i].setDoubleBuffered(true);
            this.txtArrCont[i] = new JTextField("");
            this.txtArrCont[i].setEditable(false);
            this.txtArrCont[i].setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.txtArrCont[i].setDoubleBuffered(true);
        }
        Dimension size = new Dimension(500, 600);
        this.setSize(size);
        this.setExtra(this.jPanelExtra);
        tabbedPane.addChangeListener(this);
        new EscBeenden(this){

            @Override
            public void beenden_(JDialog d) {
                d.dispose();
            }
        };
    }

    private void setExtra(JPanel jPanel) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.lblUrlThemaField = new JXHyperlink();
        this.lblUrlThemaField.setDoubleBuffered(true);
        this.lblUrlThemaField.setMinimumSize(new Dimension(10, 10));
        try {
            this.lblUrlThemaField.setAction((Action)new UrlHyperlinkAction(this.parent, ""));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.lblUrlThemaField.addMouseListener((MouseListener)new BeobMausUrl((JButton)this.lblUrlThemaField));
        this.lblUrlSubtitle = new JXHyperlink();
        this.lblUrlSubtitle.setDoubleBuffered(true);
        this.lblUrlSubtitle.setMinimumSize(new Dimension(10, 10));
        try {
            this.lblUrlSubtitle.setAction((Action)new UrlHyperlinkAction(this.parent, ""));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.lblUrlSubtitle.addMouseListener((MouseListener)new BeobMausUrl((JButton)this.lblUrlSubtitle));
        this.jLabelFilmNeu = new JLabel();
        this.jLabelFilmNeu.setOpaque(false);
        this.jLabelFilmNeu.setVisible(false);
        this.jLabelFilmNeu.setIcon(ja_sw_16);
        this.textAreaBeschreibung = new JTextArea();
        this.textAreaBeschreibung.setDoubleBuffered(true);
        this.textAreaBeschreibung.setLineWrap(true);
        this.textAreaBeschreibung.setWrapStyleWord(true);
        this.textAreaBeschreibung.setRows(4);
        this.textAreaBeschreibung.setOpaque(false);
        c.fill = 2;
        c.insets = new Insets(4, 10, 4, 10);
        c.weighty = 0.0;
        jPanel.setLayout(gridbag);
        int zeile = 0;
        for (int i = 0; i < this.labelArrNames.length; ++i) {
            if (i == 16 || i == 17 || i == 20 || i == 21 || i == 18 || i == 19 || i == 4 || i == 5 || i == 24 || i == 22 || i == 25) continue;
            c.gridy = zeile++;
            this.addLable(i, gridbag, c, jPanel);
        }
        c.weightx = 0.0;
        c.gridx = 0;
        c.weighty = 1.0;
        c.gridy = zeile;
        JLabel label = new JLabel("");
        gridbag.setConstraints(label, c);
        jPanel.add(label);
    }

    private void addLable(int i, GridBagLayout gridbag, GridBagConstraints c, JPanel panel) {
        c.gridx = 0;
        c.weightx = 0.0;
        gridbag.setConstraints(this.labelArrNames[i], c);
        panel.add(this.labelArrNames[i]);
        c.gridx = 1;
        c.weightx = 1.0;
        if (i == 13) {
            gridbag.setConstraints((Component)this.lblUrlThemaField, c);
            panel.add((Component)this.lblUrlThemaField);
        } else if (i == 15) {
            gridbag.setConstraints((Component)this.lblUrlSubtitle, c);
            panel.add((Component)this.lblUrlSubtitle);
        } else if (i == 10) {
            JScrollPane sp = new JScrollPane();
            sp.setMinimumSize(new Dimension(10, 100));
            sp.setViewportView(this.textAreaBeschreibung);
            gridbag.setConstraints(sp, c);
            panel.add(sp);
        } else if (i == 23) {
            gridbag.setConstraints(this.jLabelFilmNeu, c);
            panel.add(this.jLabelFilmNeu);
        } else {
            gridbag.setConstraints(this.txtArrCont[i], c);
            panel.add(this.txtArrCont[i]);
        }
    }

    @Override
    public void showInfo() {
        this.setAktFilm();
        super.setVisible(true);
    }

    @Override
    public void updateCurrentFilm(DatenFilm film) {
        this.aktFilm = film;
        if (this.isVisible()) {
            this.setAktFilm();
        }
    }

    private void setAktFilm() {
        if (this.aktFilm == null) {
            for (JTextField aTxtArrCont : this.txtArrCont) {
                aTxtArrCont.setText("");
            }
            this.textAreaBeschreibung.setText(" ");
            this.lblUrlThemaField.setText("");
            this.lblUrlSubtitle.setText("");
            this.jLabelFilmNeu.setVisible(false);
        } else {
            for (int i = 0; i < this.txtArrCont.length; ++i) {
                this.txtArrCont[i].setText(this.aktFilm.arr[i]);
            }
            if (this.aktFilm.arr[10].equals("")) {
                this.textAreaBeschreibung.setText(" ");
            } else {
                this.textAreaBeschreibung.setText(this.aktFilm.arr[10]);
            }
            this.lblUrlThemaField.setText(this.aktFilm.arr[13]);
            this.lblUrlSubtitle.setText(this.aktFilm.arr[15]);
            this.jLabelFilmNeu.setVisible(this.aktFilm.neuerFilm);
        }
        this.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        DatenFilm emptyFilm = new DatenFilm();
        this.updateCurrentFilm(emptyFilm);
    }

    private void initComponents() {
        this.jPanelExtra = new JPanel();
        this.setDefaultCloseOperation(2);
        this.jPanelExtra.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 477, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 650, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelExtra, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelExtra, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }
}

