/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action;

import com.pugh.sockso.ObjectCache;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.Artist;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.music.MusicSearch;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.templates.json.TFolders;
import com.pugh.sockso.templates.json.TResolvePath;
import com.pugh.sockso.templates.json.TSearch;
import com.pugh.sockso.templates.json.TServerInfo;
import com.pugh.sockso.templates.json.TSimilarArtists;
import com.pugh.sockso.templates.json.TString;
import com.pugh.sockso.templates.json.TTracks;
import com.pugh.sockso.templates.json.TTracksForPath;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.User;
import com.pugh.sockso.web.action.AudioScrobbler;
import com.pugh.sockso.web.action.WebAction;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jsoner
extends WebAction {
    private static final Logger log = Logger.getLogger(Jsoner.class);
    private final CollectionManager cm;
    private final ObjectCache cache;

    public Jsoner(CollectionManager cm, ObjectCache cache) {
        this.cm = cm;
        this.cache = cache;
    }

    @Override
    public void handleRequest() throws SQLException, IOException, BadRequestException {
        Request req = this.getRequest();
        String type = req.getUrlParam(1);
        if (type.equals("search")) {
            this.search();
        } else if (type.equals("savePlaylist")) {
            this.savePlaylist();
        } else if (type.equals("deletePlaylist")) {
            this.deletePlaylist();
        } else if (type.equals("folder")) {
            this.folder();
        } else if (type.equals("resolvePath")) {
            this.resolvePath();
        } else if (type.equals("tracksForPath")) {
            this.tracksForPath();
        } else if (type.equals("similarArtists")) {
            this.similarArtists();
        } else if (type.equals("tracks")) {
            this.tracks();
        } else if (type.equals("serverinfo")) {
            this.serverinfo();
        } else {
            throw new BadRequestException("Unknown json request (" + type + ")", 400);
        }
    }

    protected void tracks() throws IOException, SQLException, BadRequestException {
        Request req = this.getRequest();
        Vector<Track> tracks = Track.getTracksFromPlayArgs(this.getDatabase(), req.getPlayParams(true));
        this.showTracks(tracks);
    }

    protected void showTracks(Vector<Track> tracks) throws IOException {
        TTracks tpl = new TTracks();
        tpl.setTracks(tracks);
        this.getResponse().showJson(tpl.makeRenderer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void similarArtists() throws BadRequestException, SQLException, IOException {
        AudioScrobbler scrobbler = new AudioScrobbler(this.getDatabase(), this.cache);
        Request req = this.getRequest();
        int artistId = Integer.parseInt(req.getUrlParam(2));
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            Database db = this.getDatabase();
            ArrayList<Artist> artists = new ArrayList<Artist>();
            String artistSql = " '' ";
            for (String artist : scrobbler.getSimilarArtists(artistId)) {
                artistSql = artistSql + " , '" + db.escape(artist) + "' ";
            }
            String sql = " select id, name  from artists  where name in ( " + artistSql + " ) ";
            st = db.prepare(sql);
            rs = st.executeQuery();
            while (rs.next()) {
                artists.add(new Artist(rs.getInt("id"), rs.getString("name")));
            }
            this.showSimilarArtists(artists);
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
    }

    protected void showSimilarArtists(ArrayList<Artist> artists) throws IOException {
        TSimilarArtists tpl = new TSimilarArtists();
        tpl.setArtists(artists.toArray(new Artist[0]));
        this.getResponse().showJson(tpl.makeRenderer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deletePlaylist() throws BadRequestException, SQLException, IOException {
        Request req = this.getRequest();
        User user = this.getUser();
        Locale locale = this.getLocale();
        if (user == null) {
            throw new BadRequestException(locale.getString("www.json.error.notLoggedIn"), 403);
        }
        Database db = this.getDatabase();
        int id = Integer.parseInt(req.getUrlParam(2));
        String sql = " select 1  from playlists p  where p.id = ?  and p.user_id = ? ";
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            st = db.prepare(" select 1  from playlists p  where p.id = ?  and p.user_id = ? ");
            st.setInt(1, id);
            st.setInt(2, user.getId());
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new BadRequestException("You don't own that playlist", 403);
            }
            this.cm.removePlaylist(id);
            TString tpl = new TString();
            tpl.setResult(Integer.toString(id));
            this.getResponse().showJson(tpl.makeRenderer());
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tracksForPath() throws BadRequestException, SQLException, IOException {
        Utils.checkFeatureEnabled(this.getProperties(), "browse.folders.enabled");
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            Database db = this.getDatabase();
            Request req = this.getRequest();
            String path = req.getArgument("path");
            String sql = " select t.id  from tracks t  where t.path like ?  order by t.path asc ";
            st = db.prepare(" select t.id  from tracks t  where t.path like ?  order by t.path asc ");
            st.setString(1, path + "%");
            rs = st.executeQuery();
            TTracksForPath tpl = new TTracksForPath();
            tpl.setTracks(rs);
            this.getResponse().showJson(tpl.makeRenderer());
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolvePath() throws BadRequestException, SQLException, IOException {
        Utils.checkFeatureEnabled(this.getProperties(), "browse.folders.enabled");
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            Database db = this.getDatabase();
            Locale locale = this.getLocale();
            Request req = this.getRequest();
            String path = Jsoner.convertPath(req.getArgument("path"));
            String sql = Track.getSelectFromSql() + " where t.path = ? ";
            st = db.prepare(sql);
            st.setString(1, path);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new BadRequestException(locale.getString("www.error.trackNotFound"), 404);
            }
            Track track = Track.createFromResultSet(rs);
            TResolvePath tpl = new TResolvePath();
            tpl.setTrack(track);
            this.getResponse().showJson(tpl.makeRenderer());
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
    }

    protected static String convertPath(String path) {
        String separator = System.getProperty("file.separator");
        return path.replaceAll("\\/", "\\" + separator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPathFromRequest() throws SQLException, BadRequestException {
        Request req = this.getRequest();
        Locale locale = this.getLocale();
        int collectionId = Integer.parseInt(req.getArgument("collectionId"));
        String path = "";
        ResultSet rs = null;
        PreparedStatement st = null;
        for (int i = 2; i < req.getParamCount(); ++i) {
            String pathElement = req.getUrlParam(i);
            if (pathElement.equals("..")) continue;
            path = path + "/" + req.getUrlParam(i);
        }
        try {
            Database db = this.getDatabase();
            String sql = " select c.path  from collection c  where c.id = ? ";
            st = db.prepare(" select c.path  from collection c  where c.id = ? ");
            st.setInt(1, collectionId);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new BadRequestException(locale.getString("www.error.invalidCollectionId"), 404);
            }
            String collPath = rs.getString("path");
            path = collPath.substring(0, collPath.length() - 1) + path;
            path = path.replaceAll("\\/\\/", "\\/");
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        log.debug((Object)("pathFromRequest: " + path));
        return path;
    }

    protected void folder() throws BadRequestException, SQLException, IOException {
        Utils.checkFeatureEnabled(this.getProperties(), "browse.folders.enabled");
        String path = this.getPathFromRequest();
        File folder = new File(path);
        log.debug((Object)("Path: " + path));
        if (!folder.exists()) {
            throw new BadRequestException("www.error.folderDoesntExist", 404);
        }
        TFolders tpl = new TFolders();
        tpl.setFiles(this.getOrderedFiles(folder.listFiles()));
        this.getResponse().showJson(tpl.makeRenderer());
    }

    protected File[] getOrderedFiles(File[] contents) {
        File[] toSort = (File[])contents.clone();
        Arrays.sort(toSort, new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                return file1.getName().compareTo(file2.getName());
            }
        });
        return toSort;
    }

    protected void savePlaylist() throws IOException, SQLException, BadRequestException {
        Request req = this.getRequest();
        User user = this.getUser();
        Locale locale = this.getLocale();
        String name = req.getUrlParam(2).trim();
        String[] args = req.getPlayParams(2);
        String result = locale.getString("www.json.error.unknown");
        if (name.equals("")) {
            result = locale.getString("www.json.error.noName");
        } else if (args.length == 0) {
            result = locale.getString("www.json.error.noArguments");
        } else if (user == null) {
            result = locale.getString("www.json.error.notLoggedIn");
        } else {
            Database db = this.getDatabase();
            Vector<Track> vTracks = Track.getTracksFromPlayArgs(db, args);
            Track[] tracks = new Track[vTracks.size()];
            for (int i = 0; i < vTracks.size(); ++i) {
                tracks[i] = vTracks.elementAt(i);
            }
            result = Integer.toString(this.cm.savePlaylist(name, tracks, user));
        }
        TString tpl = new TString();
        tpl.setResult(result);
        this.getResponse().showJson(tpl.makeRenderer());
    }

    public void search() throws SQLException, IOException {
        MusicSearch musicSearch = new MusicSearch(this.getDatabase());
        Request req = this.getRequest();
        String query = req.getUrlParam(2);
        TSearch tpl = new TSearch();
        tpl.setItems(musicSearch.search(query));
        this.getResponse().showJson(tpl.makeRenderer());
    }

    protected void serverinfo() throws IOException {
        TServerInfo tpl = new TServerInfo();
        tpl.setProperties(this.getProperties());
        this.getResponse().showJson(tpl.makeRenderer());
    }

    @Override
    public boolean requiresLogin() {
        return !this.getRequest().getUrlParam(1).equals("serverinfo");
    }
}

