/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.web.action.CoverSearch;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public abstract class AbstractCoverSearch
implements CoverSearch {
    private static final Logger log = Logger.getLogger(AbstractCoverSearch.class);
    protected final Database db;

    public AbstractCoverSearch(Database db) {
        this.db = db;
    }

    protected String getCustomTypeFromAbrev(String type) {
        if (type.equals("pl")) {
            return "playlist";
        }
        if (type.equals("ar")) {
            return "artist";
        }
        if (type.equals("al")) {
            return "album";
        }
        if (type.equals("tr")) {
            return "track";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getMusicItemName(String arg) {
        PreparedStatement st;
        ResultSet rs;
        block7: {
            String string;
            block6: {
                String type = this.getCustomTypeFromAbrev(arg.substring(0, 2));
                int id = Integer.parseInt(arg.substring(2));
                rs = null;
                st = null;
                try {
                    String sql = " select name as name  from " + type + "s " + " where id = ? ";
                    st = this.db.prepare(sql);
                    st.setInt(1, id);
                    rs = st.executeQuery();
                    if (rs.next()) {
                        string = rs.getString("name");
                        Utils.close(rs);
                        break block6;
                    }
                    Utils.close(rs);
                    break block7;
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                    return null;
                }
            }
            Utils.close(st);
            return string;
        }
        Utils.close(st);
        return null;
        finally {
            Utils.close(rs);
            Utils.close(st);
        }
    }

    protected String getSearchKeywords(String arg) {
        String keywords = this.getMusicItemName(arg);
        if (keywords == null) {
            return null;
        }
        if (arg.substring(0, 2).equals("al")) {
            keywords = this.getArtistName(Integer.parseInt(arg.substring(2))) + " " + keywords;
        }
        keywords = this.removeUselessWords(keywords);
        return keywords;
    }

    protected String removeUselessWords(String keywords) {
        keywords = Utils.replaceAll("cd\\s*\\d+", "", keywords);
        keywords = Utils.replaceAll("disc\\s*\\d+", "", keywords);
        return keywords.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getArtistName(int albumId) {
        PreparedStatement st;
        ResultSet rs;
        block4: {
            String string;
            rs = null;
            st = null;
            try {
                String sql = " select ar.name as name  from albums al  inner join artists ar  on ar.id = al.artist_id  where al.id = ? ";
                st = this.db.prepare(" select ar.name as name  from albums al  inner join artists ar  on ar.id = al.artist_id  where al.id = ? ");
                st.setInt(1, albumId);
                rs = st.executeQuery();
                if (!rs.next()) break block4;
                string = rs.getString("name");
            }
            catch (SQLException e) {
                try {
                    log.debug((Object)e);
                }
                catch (Throwable throwable) {
                    Utils.close(rs);
                    Utils.close(st);
                    throw throwable;
                }
                Utils.close(rs);
                Utils.close(st);
            }
            Utils.close(rs);
            Utils.close(st);
            return string;
        }
        Utils.close(rs);
        Utils.close(st);
        return "";
    }
}

