/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class User {
    private static final Logger log = Logger.getLogger(User.class);
    private final int sessionId;
    private final String name;
    private final String pass;
    private final String email;
    private final String sessionCode;
    private final boolean isAdmin;
    private boolean isActive;
    private int id;

    public User(int id, String name) {
        this(id, name, "", "");
    }

    public User(String name, String pass, String email, boolean isAdmin) {
        this(-1, name, pass, email, -1, "", isAdmin);
    }

    public User(int id, String name, String email, boolean isAdmin) {
        this(id, name, "", email, -1, "", isAdmin);
    }

    public User(int id, String name, String pass, String email) {
        this(id, name, pass, email, -1, "", false);
    }

    public User(int id, String name, String pass, String email, int sessionId, String sessionCode, boolean isAdmin) {
        this.id = id;
        this.name = name;
        this.pass = pass;
        this.email = email;
        this.sessionId = sessionId;
        this.sessionCode = sessionCode;
        this.isAdmin = isAdmin;
        this.isActive = true;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public String getSessionCode() {
        return this.sessionCode;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Database db) throws SQLException {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            String sql = " insert into users ( name, pass, email, date_created, is_admin, is_active )  values ( ?, ?, ?, current_timestamp, ?, ? ) ";
            st = db.prepare(sql);
            st.setString(1, this.name);
            st.setString(2, Utils.md5(this.pass));
            st.setString(3, this.email);
            st.setInt(4, this.isAdmin ? 1 : 0);
            st.setString(5, this.isActive ? "1" : "0");
            st.executeUpdate();
            Utils.close(st);
            sql = " select max(id) as new_id  from users ";
            st = db.prepare(sql);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new SQLException("No results returned from aggregate query");
            }
            this.id = rs.getInt("new_id");
        }
        catch (Throwable throwable) {
            Utils.close(st);
            throw throwable;
        }
        Utils.close(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Database db) throws SQLException {
        PreparedStatement st = null;
        try {
            String sql = " update users  set name = ?,  email = ?,  is_admin = ?,  is_active = ?  where id = ? ";
            st = db.prepare(" update users  set name = ?,  email = ?,  is_admin = ?,  is_active = ?  where id = ? ");
            st.setString(1, this.getName());
            st.setString(2, this.getEmail());
            st.setInt(3, this.isAdmin() ? 1 : 0);
            st.setString(4, this.isActive() ? "1" : "0");
            st.setInt(5, this.getId());
            log.debug((Object)("Update user [" + this.getId() + "]: " + " update users  set name = ?,  email = ?,  is_admin = ?,  is_active = ?  where id = ? "));
            log.debug((Object)("Name: " + this.getName()));
            log.debug((Object)("Email: " + this.getEmail()));
            log.debug((Object)("Admin: " + (this.isAdmin() ? "1" : "0")));
            log.debug((Object)("Active: " + (this.isActive() ? "1" : "0")));
            st.executeUpdate();
        }
        catch (Throwable throwable) {
            Utils.close(st);
            throw throwable;
        }
        Utils.close(st);
    }

    public static User find(Database db, int id) {
        String sql = " select id, name, email, is_admin, is_active  from users  where id = ? ";
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = db.prepare(" select id, name, email, is_admin, is_active  from users  where id = ? ");
            st.setInt(1, id);
            rs = st.executeQuery();
            if (rs.next()) {
                User user = new User(id, rs.getString("name"), rs.getString("email"), rs.getBoolean("is_admin"));
                user.setActive(rs.getString("is_active").equals("1"));
                return user;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(Database db, int id) throws SQLException {
        boolean bl;
        PreparedStatement st = null;
        try {
            String sql = " delete from playlist_tracks  where playlist_id in (  select id  from playlists  where user_id = ?  ) ";
            st = db.prepare(sql);
            st.setInt(1, id);
            st.execute();
            st.close();
            sql = " delete from playlists  where user_id = ? ";
            st = db.prepare(sql);
            st.setInt(1, id);
            st.execute();
            st.close();
            sql = " delete from users  where id = ? ";
            st = db.prepare(sql);
            st.setInt(1, id);
            int affectedRows = st.executeUpdate();
            st.close();
            bl = affectedRows == 1;
        }
        catch (Throwable throwable) {
            Utils.close(st);
            throw throwable;
        }
        Utils.close(st);
        return bl;
    }
}

