/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web;

import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.Request;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Vector;

public class Submission {
    public static final int FIELD_TEXT = 1;
    public static final int FIELD_EMAIL = 2;
    public static final int FIELD_DATE = 3;
    public static final int FIELD_INTEGER = 4;
    private final Vector<String> errors;
    private final Request req;
    private final Locale locale;

    public Submission(Request req, Locale locale) {
        this.req = req;
        this.locale = locale;
        this.errors = new Vector();
    }

    public void addField(String name, int type) {
        this.addField(name, type, true, "");
    }

    public void addField(String name, int type, String localeKey) {
        this.addField(name, type, true, localeKey);
    }

    public void addField(String name, int type, boolean isRequired) {
        this.addField(name, type, isRequired, "");
    }

    public void addField(String name, int type, boolean isRequired, String localeKey) {
        String value = this.req.getArgument(name);
        if (value.equals("") && isRequired) {
            this.addError("required field missing", localeKey);
        } else if (isRequired && !value.equals("")) {
            switch (type) {
                case 2: {
                    if (this.isValidEmail(value)) break;
                    this.addError("invalid email", localeKey);
                    break;
                }
                case 4: {
                    if (this.isValidInteger(value)) break;
                    this.addError("invalid integer", localeKey);
                    break;
                }
                case 3: {
                    if (this.isValidDate(value)) break;
                    this.addError("invalid date", localeKey);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    this.addError("unknown field type (dev error?)", localeKey);
                }
            }
        }
    }

    public void addMatchingFields(String field1, String field2, String localeKey) {
        String value2;
        String value1 = this.req.getArgument(field1);
        if (!value1.equals(value2 = this.req.getArgument(field2))) {
            this.addError("fields dont match", localeKey);
        }
    }

    public void validate() throws BadRequestException {
        if (!this.isValid()) {
            throw new BadRequestException(this.getErrors());
        }
    }

    public void addError(String message, String localeKey) {
        this.errors.add(localeKey.equals("") ? message : this.locale.getString(localeKey));
    }

    public String[] getErrors() {
        return this.errors.toArray(new String[0]);
    }

    private boolean isValidDate(String value) {
        try {
            DateFormat df = DateFormat.getDateInstance(3);
            df.setLenient(true);
            df.parse(value);
        }
        catch (ParseException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private boolean isValidInteger(String integer) {
        try {
            Integer.parseInt(integer);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isValidEmail(String email) {
        String pattern = "^[a-zA-Z][\\w\\.-]*[a-zA-Z0-9]@[a-zA-Z0-9][\\w\\.-]*[a-zA-Z0-9]\\.[a-zA-Z][a-zA-Z\\.]*[a-zA-Z]$";
        return email.matches("^[a-zA-Z][\\w\\.-]*[a-zA-Z0-9]@[a-zA-Z0-9][\\w\\.-]*[a-zA-Z0-9]\\.[a-zA-Z][a-zA-Z\\.]*[a-zA-Z]$");
    }

    public boolean isValid() {
        return this.errors.size() == 0;
    }
}

