/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.web.HttpResponseCookie;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.Response;
import com.pugh.sockso.web.User;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public class Session {
    protected static final String SESS_ID_COOKIE = "sessId";
    protected static final String SESS_CODE_COOKIE = "sessCode";
    private final Logger log = Logger.getLogger(Session.class);
    private final Database db;
    private final Request req;
    private final Response res;

    public Session(Database db, Request req, Response res) {
        this.db = db;
        this.req = req;
        this.res = res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(int userId) throws SQLException {
        PreparedStatement st = null;
        ResultSet rs = null;
        String sql = "";
        try {
            String sessCode = Utils.getRandomString(10);
            sql = " insert into sessions ( code, user_id, date_created )  values ( ?, ?, current_timestamp ); ";
            st = this.db.prepare(sql);
            st.setString(1, sessCode);
            st.setInt(2, userId);
            st.execute();
            Utils.close(st);
            sql = " select s.id as id  from sessions s  where s.code = ?  and s.user_id = ?  order by s.date_created desc  limit 1 ";
            st = this.db.prepare(sql);
            st.setString(1, sessCode);
            st.setInt(2, userId);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new SQLException("could not fetch session id");
            }
            int sessId = rs.getInt("id");
            this.res.addCookie(new HttpResponseCookie(SESS_ID_COOKIE, Integer.toString(sessId)));
            this.res.addCookie(new HttpResponseCookie(SESS_CODE_COOKIE, sessCode));
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
    }

    public void destroy() {
        this.res.addCookie(new HttpResponseCookie(SESS_ID_COOKIE, "", new Date(), "/"));
        this.res.addCookie(new HttpResponseCookie(SESS_CODE_COOKIE, "", new Date(), "/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User getCurrentUser() throws SQLException {
        User user;
        block6: {
            user = null;
            ResultSet rs = null;
            PreparedStatement st = null;
            try {
                int sessId = this.fetchSessionId(this.req);
                String sessCode = this.fetchSessionCode(this.req);
                String sql = " select u.id, u.name, u.email, u.is_admin  from users u  inner join sessions s  on s.user_id = u.id  where s.id = ?  and s.code = ? ";
                st = this.db.prepare(" select u.id, u.name, u.email, u.is_admin  from users u  inner join sessions s  on s.user_id = u.id  where s.id = ?  and s.code = ? ");
                st.setInt(1, sessId);
                st.setString(2, sessCode);
                rs = st.executeQuery();
                if (rs.next()) {
                    user = new User(rs.getInt("id"), rs.getString("name"), "", rs.getString("email"), sessId, sessCode, rs.getBoolean("is_admin"));
                }
                Utils.close(rs);
            }
            catch (NumberFormatException e) {
                this.log.error((Object)e);
                break block6;
            }
            finally {
                Utils.close(rs);
                Utils.close(st);
            }
            Utils.close(st);
        }
        return user;
    }

    protected int fetchSessionId(Request req) {
        try {
            String[] sessIds;
            for (String sessId : sessIds = new String[]{req.getCookie(SESS_ID_COOKIE), req.getArgument(SESS_ID_COOKIE)}) {
                if (!sessId.matches("^\\d+$")) continue;
                return Integer.parseInt(sessId);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    protected String fetchSessionCode(Request req) {
        String[] sessCodes;
        for (String sessCode : sessCodes = new String[]{req.getCookie(SESS_CODE_COOKIE), req.getArgument(SESS_CODE_COOKIE)}) {
            if (sessCode.equals("")) continue;
            return sessCode;
        }
        return "";
    }
}

