/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputBuffer {
    private static final int BUFFER_MAX_SIZE = 1024;
    private static final int DEFAULT_END_OF_STREAM_WAIT = 100;
    private final DataInputStream in;
    private final int endOfStreamWait;
    private int[] queue;
    private int head;
    private int tail;
    private int read;

    public InputBuffer(InputStream in) {
        this(in, 100);
    }

    public InputBuffer(InputStream in, int endOfStreamWait) {
        this.in = new DataInputStream(in);
        this.endOfStreamWait = endOfStreamWait;
        this.queue = new int[1024];
        this.head = 0;
        this.tail = 0;
        this.read = 0;
    }

    public int read() throws IOException {
        return this.head != this.tail ? this.queue[this.head++] : this.readDirectly();
    }

    public int readDirectly() throws IOException {
        if (this.read > 0 && this.in.available() == 0) {
            try {
                Thread.sleep(this.endOfStreamWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.read++ > 0 && this.in.available() == 0 ? -1 : this.in.read();
    }

    public void putBack(int i) {
        if (this.tail >= this.queue.length) {
            int[] newQueue = new int[this.queue.length + 1024];
            System.arraycopy(this.queue, this.head, newQueue, 0, this.tail - this.head);
            this.queue = newQueue;
            this.tail -= this.head;
            this.head = 0;
        }
        this.queue[this.tail++] = i;
    }

    public String readLine() throws IOException {
        StringBuffer sb = new StringBuffer();
        char l = '\u0000';
        int i;
        while ((i = this.read()) != -1) {
            char c = (char)i;
            if (c == '\n') {
                String s = sb.toString();
                return s.substring(0, s.length() - (l == '\r' ? 1 : 0));
            }
            sb.append(c);
            l = c;
        }
        return sb.toString();
    }

    public String readString() throws IOException {
        return this.readString(-1);
    }

    public String readString(int length) throws IOException {
        StringBuffer sb = new StringBuffer();
        int lengthRead = 0;
        int i = this.read();
        while (i != -1 && (length == -1 || lengthRead++ < length)) {
            sb.append((char)i);
            i = this.read();
        }
        return sb.toString();
    }

    public void skip(int amount) throws IOException {
        int removeAmount = amount;
        if (this.head != this.tail) {
            while (removeAmount > 0) {
                --removeAmount;
                if (this.head == this.tail) break;
                ++this.head;
            }
        }
        this.in.skip(removeAmount);
    }
}

