/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.resources;

import com.pugh.sockso.resources.AbstractResources;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class FileResources
extends AbstractResources {
    private static final String resourcesDir = (new File("../resources").exists() ? "../" : "") + "resources/";

    public FileResources() {
        log.debug((Object)"Created FileResources()");
    }

    public InputStream getResourceAsStream(String name) {
        FileInputStream in = null;
        try {
            String path = this.getResourcePath(name);
            in = new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
        }
        return in;
    }

    public Image getImage(String name) {
        String path = this.getResourcePath(name);
        return Toolkit.getDefaultToolkit().createImage(path);
    }

    protected String getResourcePath(String name) {
        return resourcesDir + name;
    }

    public String[] getLocales() {
        File localeDir = new File(resourcesDir + "locales");
        return FileResources.getLocalesFromFiles(localeDir.list());
    }

    static {
        log.debug((Object)("FileResources: dir=" + resourcesDir));
    }
}

