/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.resources;

import com.pugh.sockso.resources.FileLocale;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.resources.Resources;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractResources
implements Resources {
    private Hashtable<String, Locale> locales = null;
    private String localeCode = "en";
    private String[] localeCodes;

    public void init(String localeCode) {
        this.localeCodes = this.getLocales();
        this.localeCode = localeCode;
    }

    public abstract String[] getLocales();

    public Locale getLocale(String locale) {
        if (this.locales == null) {
            FileLocale defaultLocale = new FileLocale(this, "en");
            this.locales = new Hashtable();
            for (String lc : this.localeCodes) {
                this.locales.put(lc, new FileLocale(this, lc, defaultLocale));
            }
        }
        if (this.locales.get(locale) != null) {
            return this.locales.get(locale);
        }
        return this.locales.get("en");
    }

    public Locale getCurrentLocale() {
        return this.getLocale(this.localeCode);
    }

    public void setCurrentLocaleCode(String newLocale) {
        this.localeCode = newLocale;
    }

    protected static String[] getLocalesFromFiles(String[] files) {
        Vector<String> codes = new Vector<String>();
        for (int i = 0; i < files.length; ++i) {
            Pattern p = Pattern.compile("sockso.(.*).txt");
            Matcher m = p.matcher(files[i]);
            if (!m.matches()) continue;
            codes.addElement(m.group(1));
        }
        return codes.toArray(new String[codes.size()]);
    }
}

