/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music.tag;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class CountingInputStream
extends FilterInputStream {
    private int _count = 0;

    public CountingInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        int read = super.read();
        if (read != -1) {
            ++this._count;
        }
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        try {
            read = super.read(b, off, len);
        }
        catch (ArrayIndexOutOfBoundsException aioob) {
            throw new IOException();
        }
        if (read != -1) {
            this._count += read;
        }
        return read;
    }

    public long skip(long n) throws IOException {
        long skipped = super.skip(n);
        this._count += (int)skipped;
        return skipped;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int getAmountRead() {
        return this._count;
    }

    public void clearAmountRead() {
        this._count = 0;
    }
}

