/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music.tag;

import com.pugh.sockso.Utils;
import com.pugh.sockso.music.tag.AACTag;
import com.pugh.sockso.music.tag.FlacTag;
import com.pugh.sockso.music.tag.InvalidTagException;
import com.pugh.sockso.music.tag.Mp3Tag;
import com.pugh.sockso.music.tag.OggTag;
import com.pugh.sockso.music.tag.Tag;
import com.pugh.sockso.music.tag.WmaTag;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public abstract class AudioTag
implements Tag {
    private static final Logger log = Logger.getLogger(AudioTag.class);
    protected String artistTitle = "";
    protected String albumTitle = "";
    protected String trackTitle = "";
    protected String albumYear = "";
    protected int trackNumber = 0;

    public String getArtist() {
        return this.artistTitle;
    }

    public String getAlbum() {
        return this.albumTitle;
    }

    public String getTrack() {
        return this.trackTitle;
    }

    public int getTrackNumber() {
        return this.trackNumber;
    }

    public String getAlbumYear() {
        return this.albumYear;
    }

    public static Tag getTag(File file) throws IOException, InvalidTagException {
        String ext = Utils.getExt(file);
        AudioTag tag = null;
        if (ext.equals("mp3")) {
            tag = new Mp3Tag();
        } else if (ext.equals("ogg")) {
            tag = new OggTag();
        } else if (ext.equals("wma") || ext.equals("asf")) {
            tag = new WmaTag();
        } else if (ext.equals("flac")) {
            tag = new FlacTag();
        } else if (ext.equals("m4a")) {
            tag = new AACTag();
        } else {
            throw new InvalidTagException(file);
        }
        tag.parse(file);
        if (tag.artistTitle == null) {
            tag.artistTitle = "";
        }
        if (tag.albumTitle == null) {
            tag.albumTitle = "";
        }
        if (tag.trackTitle == null) {
            tag.trackTitle = "";
        }
        if (tag.albumYear == null) {
            tag.albumYear = "";
        }
        tag.albumTitle = tag.albumTitle.trim();
        tag.artistTitle = tag.artistTitle.trim();
        tag.trackTitle = tag.trackTitle.trim();
        tag.albumYear = tag.albumYear.trim();
        if (tag.artistTitle.equals("")) {
            tag.artistTitle = AudioTag.guessArtist(file);
        }
        if (tag.albumTitle.equals("")) {
            tag.albumTitle = AudioTag.guessAlbum(file);
        }
        if (tag.trackTitle.equals("")) {
            tag.trackTitle = AudioTag.guessTrack(file);
        }
        if (tag.trackNumber == 0) {
            tag.setTrackNumber(AudioTag.guessTrackNumber(file));
        }
        return tag;
    }

    protected void setTrackNumber(String strNumber) {
        try {
            this.trackNumber = Integer.parseInt(AudioTag.checkTrackNumberForTotal(strNumber));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected static String checkTrackNumberForTotal(String trackNumber) {
        Pattern p = Pattern.compile("(\\d+)/\\d+");
        Matcher m = p.matcher(trackNumber);
        return m.matches() ? m.group(1) : trackNumber;
    }

    protected static String guessArtist(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            String parentName = parent.getName();
            String[] splits = new String[]{" - ", "_-_"};
            for (int i = 0; i < splits.length; ++i) {
                if (parentName.indexOf(splits[i]) == -1) continue;
                return parentName.substring(0, parentName.indexOf(splits[i]));
            }
            if (parent.getParent() != null) {
                return parent.getParentFile().getName();
            }
        }
        return "(Unknown Artist)";
    }

    protected static String guessAlbum(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            String parentName = parent.getName();
            String[] splits = new String[]{" - ", "_-_"};
            for (int i = 0; i < splits.length; ++i) {
                if (parentName.indexOf(splits[i]) == -1) continue;
                return parentName.substring(parentName.indexOf(splits[i]) + splits[i].length(), parentName.length());
            }
            return parent.getName();
        }
        return "(Unknown Album)";
    }

    protected static String guessTrack(File file) {
        String[] regexs = new String[]{"\\d+ - (.*)\\.\\w+", "\\d+_-_(.*)\\.\\w+", "\\d+-(.*)\\.\\w+", "(.*)\\.\\w"};
        String name = file.getName();
        return AudioTag.matchRegex(name, regexs, file.getName());
    }

    private static String matchRegex(String str, String[] regexs, String defaultValue) {
        for (int i = 0; i < regexs.length; ++i) {
            String regex = regexs[i];
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(str);
            if (!m.matches()) continue;
            return m.group(1);
        }
        return defaultValue;
    }

    protected static String guessTrackNumber(File file) {
        String[] regexs = new String[]{"(\\d+).*"};
        String name = file.getName();
        return AudioTag.matchRegex(name, regexs, "0");
    }
}

