/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music.scheduling;

import com.pugh.sockso.Properties;
import com.pugh.sockso.music.scheduling.Scheduler;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class CronScheduler
implements Scheduler {
    private static final Logger log = Logger.getLogger(CronScheduler.class);
    private static final String DEFAULT_TAB = "*/30 * * * *";
    private final Properties p;

    public CronScheduler(Properties p) {
        this.p = p;
    }

    public boolean shouldRunAt(Date date) {
        try {
            String spec = this.p.get("scheduler.cron.tab", DEFAULT_TAB);
            String[] patterns = this.getPatterns(spec);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return this.matchesPattern(cal.get(12), patterns[0]) && this.matchesPattern(cal.get(10), patterns[1]) && this.matchesPattern(cal.get(5), patterns[2]) && this.matchesPattern(cal.get(2) + 1, this.getMonth(patterns[3])) && this.matchesPattern(cal.get(7) - 1, this.getDayOfWeek(patterns[4])) || !patterns[2].equals("*") && !patterns[4].equals("*") && (this.matchesPattern(cal.get(5), patterns[2]) || this.matchesPattern(cal.get(7) - 1, this.getDayOfWeek(patterns[4])));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean matchesPattern(int toMatch, String pattern) {
        if (pattern.equals("*")) {
            return true;
        }
        if (pattern.contains("/")) {
            int divisor = Integer.parseInt(pattern.substring(2));
            return toMatch % divisor == 0;
        }
        if (pattern.contains("-")) {
            int dashIndex = pattern.indexOf("-");
            int from = Integer.parseInt(pattern.substring(0, dashIndex));
            int to = Integer.parseInt(pattern.substring(dashIndex + 1));
            for (int i = from; i <= to; ++i) {
                if (toMatch != i) continue;
                return true;
            }
        } else if (pattern.contains(",")) {
            String[] units;
            for (String unit : units = pattern.split(",")) {
                if (toMatch != Integer.parseInt(unit)) continue;
                return true;
            }
        } else if (toMatch == Integer.parseInt(pattern)) {
            return true;
        }
        return false;
    }

    private String getMonth(String month) {
        String[] replacements = new String[]{"jan", "1", "feb", "2", "mar", "3", "apr", "4", "may", "5", "jun", "6", "jul", "7", "aug", "8", "sep", "9", "oct", "10", "nov", "11", "dec", "12"};
        return this.replaceWords(month, replacements);
    }

    private String getDayOfWeek(String dayOfWeek) {
        String[] replacements = new String[]{"sun", "0", "mon", "1", "tue", "2", "wed", "3", "thu", "4", "fri", "5", "sat", "6"};
        return this.replaceWords(dayOfWeek, replacements).replaceAll("7", "0");
    }

    private String replaceWords(String phrase, String[] replacements) {
        String newPhrase = phrase;
        for (int i = 0; i < replacements.length; i += 2) {
            newPhrase = newPhrase.replaceAll(replacements[i], replacements[i + 1]);
        }
        return newPhrase;
    }

    private String[] getPatterns(String spec) {
        String[] replacements = new String[]{"@yearly", "0 0 1 1 *", "@annually", "0 0 1 1 *", "@monthly", "0 0 1 * *", "@weekly", "0 0 * * 0", "@daily", "0 0 * * *", "@midnight", "0 0 * * *", "@hourly", "0 * * * *"};
        return this.replaceWords(spec, replacements).split(" ");
    }
}

