/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music.indexing;

import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.indexing.IndexCache;
import com.pugh.sockso.music.indexing.IndexEvent;
import com.pugh.sockso.music.indexing.IndexListener;
import com.pugh.sockso.music.indexing.Indexer;
import java.io.File;
import java.io.FileFilter;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class BaseIndexer
implements Indexer {
    public static Logger log = Logger.getLogger(BaseIndexer.class);
    private final Vector<IndexListener> indexListeners;
    private final Database db;
    private final IndexCache cache;
    private boolean isIndexing;

    public BaseIndexer(Database db) {
        this(db, new IndexCache());
    }

    public BaseIndexer(Database db, IndexCache cache) {
        this.db = db;
        this.cache = cache;
        this.indexListeners = new Vector();
        this.isIndexing = false;
    }

    protected abstract FileFilter getFileFilter();

    protected abstract String getFilesSql();

    protected abstract String getDirectoriesSql();

    public void scan() {
        if (!this.isIndexing) {
            this.isIndexing = true;
            long start = System.currentTimeMillis();
            log.debug((Object)"scan() starting...");
            this.checkIntegrity();
            log.debug((Object)("integrity check done: " + (System.currentTimeMillis() - start)));
            this.checkForNewFiles();
            log.debug((Object)("scan() finished: " + (System.currentTimeMillis() - start)));
            this.fireIndexEvent(new IndexEvent(4, -1, new File("")));
            this.isIndexing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForNewFiles() {
        ResultSet rs = null;
        try {
            this.updateCache();
            rs = this.getDirectories();
            while (rs.next()) {
                this.scan(rs.getInt("id"), new File(rs.getString("path")));
            }
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkIntegrity() {
        ResultSet rs = null;
        try {
            rs = this.getFiles();
            while (rs.next()) {
                int id;
                String path = rs.getString("file_path");
                File file = new File(path);
                if (!this.checkExists(file, id = rs.getInt("file_id")) || !this.checkModified(file, id, rs.getDate("index_last_modified"))) continue;
                this.markFileModified(id, rs.getInt("index_id"));
            }
        }
        catch (SQLException e) {
            log.debug((Object)e);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCache() throws SQLException {
        ResultSet rs = null;
        try {
            this.cache.clear();
            rs = this.getFiles();
            while (rs.next()) {
                this.cache.add(rs.getString("file_path"));
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void scanDirectory(int directoryId, File directory) throws SQLException {
        this.updateCache();
        this.scan(directoryId, directory);
    }

    protected void scan(int directoryId, File directory) {
        if (!directory.exists() || !directory.canRead()) {
            return;
        }
        for (File file : directory.listFiles(this.getFileFilter())) {
            if (file.isDirectory()) {
                this.scan(directoryId, file);
                continue;
            }
            if (this.cache.exists(file.getAbsolutePath())) continue;
            this.fireIndexEvent(new IndexEvent(1, directoryId, file));
        }
    }

    protected ResultSet getDirectories() throws SQLException {
        String sql = this.getDirectoriesSql();
        PreparedStatement st = this.db.prepare(sql);
        return st.executeQuery();
    }

    protected ResultSet getFiles() throws SQLException {
        String sql = this.getFilesSql();
        PreparedStatement st = this.db.prepare(sql);
        return st.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markFileModified(int fileId, int indexId) {
        Statement st = null;
        try {
            String sql = "";
            if (indexId == 0) {
                sql = " insert into indexer ( id, last_modified )  values ( ?, current_timestamp ) ";
                st = this.db.prepare(sql);
                st.setInt(1, fileId);
            } else {
                sql = " update indexer  set last_modified = current_timestamp  where id = ? ";
                st = this.db.prepare(sql);
                st.setInt(1, indexId);
            }
            st.execute();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            log.debug((Object)e);
        }
        finally {
            try {
                st.close();
            }
            catch (SQLException e) {}
        }
        return false;
    }

    protected boolean checkExists(File file, int id) throws SQLException {
        if (!file.exists()) {
            this.fireIndexEvent(new IndexEvent(2, id, file));
            return false;
        }
        return true;
    }

    protected boolean checkModified(File file, int id, Date lastModified) throws SQLException {
        if (lastModified == null || lastModified.getTime() < file.lastModified()) {
            this.fireIndexEvent(new IndexEvent(3, id, file));
            return true;
        }
        return false;
    }

    protected void fireIndexEvent(IndexEvent evt) {
        log.debug((Object)evt);
        for (IndexListener listener : this.indexListeners) {
            listener.indexChanged(evt);
        }
    }

    public void addIndexListener(IndexListener listener) {
        this.indexListeners.add(listener);
    }
}

