/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui.controls;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.gui.controls.DirectoryOptionField;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.resources.Locale;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class UploadDirectoryOptionField
extends DirectoryOptionField {
    private static final Logger log = Logger.getLogger(UploadDirectoryOptionField.class);
    private Database db;
    private Properties p;
    private CollectionManager cm;

    public UploadDirectoryOptionField(JFrame parent, Properties p, String name, Locale locale, Database db, CollectionManager cm) {
        super(parent, p, name, locale);
        this.p = p;
        this.db = db;
        this.cm = cm;
        this.setPath(Utils.getUploadsPath(db, p));
    }

    public void actionPerformed(ActionEvent evt) {
        File folder = null;
        folder = this.chooseFolder();
        if (folder != null) {
            String newPath = folder.getAbsolutePath();
            String oldPath = Utils.getUploadsPath(this.db, this.p);
            if (!oldPath.equals(newPath)) {
                if (!oldPath.equals("")) {
                    this.cm.removeDirectory(oldPath);
                }
                File uploadsDir = new File(newPath);
                int newCollectionId = this.cm.addDirectory(uploadsDir);
                this.p.set("uploads.collectionId", newCollectionId);
                this.p.save();
                this.setPath(newPath);
            }
        }
    }
}

