/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.resources.Resources;
import com.pugh.sockso.web.IpFinder;
import com.pugh.sockso.web.Server;
import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.awt.Cursor;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

class UrlLabelMouseAdapter
extends MouseAdapter {
    private static final Logger log = Logger.getLogger(UrlLabelMouseAdapter.class);
    private final JFrame parent;
    private final Server sv;
    private final Resources r;
    private final JPopupMenu menu;
    private final IpFinder ipFinder;

    public UrlLabelMouseAdapter(JFrame parent, Server sv, Resources r, IpFinder ipFinder) {
        this.parent = parent;
        this.sv = sv;
        this.r = r;
        this.ipFinder = ipFinder;
        this.menu = this.createPopupMenu();
    }

    public void mouseEntered(MouseEvent evt) {
        this.parent.setCursor(new Cursor(12));
    }

    public void mouseExited(MouseEvent evt) {
        this.parent.setCursor(new Cursor(0));
    }

    public void mouseClicked(MouseEvent evt) {
        try {
            this.menu.show((JLabel)evt.getSource(), evt.getX(), evt.getY());
        }
        catch (IllegalComponentStateException e) {
            log.error((Object)e);
        }
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        Locale locale = this.r.getCurrentLocale();
        JMenuItem inet = new JMenuItem(locale.getString("gui.label.internetAddress"));
        inet.setFont(inet.getFont().deriveFont(1));
        inet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UrlLabelMouseAdapter.this.openUrl(UrlLabelMouseAdapter.this.sv.getProtocol() + "://" + UrlLabelMouseAdapter.this.sv.getHost());
            }
        });
        JMenuItem local = new JMenuItem(locale.getString("gui.label.myComputer"));
        local.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UrlLabelMouseAdapter.this.openUrl(UrlLabelMouseAdapter.this.sv.getProtocol() + "://127.0.0.1:" + UrlLabelMouseAdapter.this.sv.getPort());
            }
        });
        JMenuItem refresh = new JMenuItem(locale.getString("gui.label.refresh"), new ImageIcon(this.r.getImage("icons/16x16/refresh.png")));
        refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UrlLabelMouseAdapter.this.ipFinder.refresh();
                JOptionPane.showMessageDialog(UrlLabelMouseAdapter.this.parent, "IP Updated!");
            }
        });
        popup.add(inet);
        popup.add(local);
        popup.addSeparator();
        popup.add(refresh);
        return popup;
    }

    private void openUrl(String url) {
        String errMsg = "Error attempting to launch web browser: ";
        boolean error = true;
        log.debug((Object)("Opening URL " + url));
        try {
            BrowserLauncher launcher = new BrowserLauncher();
            launcher.openURLinBrowser(url);
            error = false;
        }
        catch (UnsupportedOperatingSystemException e) {
            log.error((Object)e);
            errMsg = errMsg + e.getLocalizedMessage();
        }
        catch (BrowserLaunchingInitializingException e) {
            log.error((Object)e);
            errMsg = errMsg + e.getLocalizedMessage();
        }
        if (error) {
            JOptionPane.showMessageDialog(null, errMsg);
        }
    }
}

