/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.pugh.sockso.gui.MusicTreeNode;
import com.pugh.sockso.music.MusicItem;
import com.pugh.sockso.resources.Resources;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.Logger;

public class MusicTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static Logger log = Logger.getLogger(MusicTreeCellRenderer.class);
    private final Resources r;

    public MusicTreeCellRenderer(Resources r) {
        this.r = r;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value.getClass().equals(MusicTreeNode.class)) {
            MusicTreeNode node = (MusicTreeNode)value;
            MusicItem item = (MusicItem)node.getUserObject();
            String type = item.getType();
            if (type.equals("collection")) {
                this.setIcon(new ImageIcon(this.r.getImage("icons/16x16/collection.png")));
            } else if (type.equals("artist")) {
                this.setIcon(new ImageIcon(this.r.getImage("icons/16x16/artist.png")));
            } else if (type.equals("album")) {
                this.setIcon(new ImageIcon(this.r.getImage("icons/16x16/album.png")));
            } else if (type.equals("track")) {
                this.setIcon(new ImageIcon(this.r.getImage("icons/16x16/tracks.png")));
            }
        }
        return this;
    }
}

