/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.music.CollectionManagerListener;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.resources.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CollectionPanel
extends JPanel
implements CollectionManagerListener {
    private DefaultListModel listModel;
    private JList list;
    private JLabel feedback;
    private final JFrame parent;
    private final Database db;
    private final CollectionManager cm;
    private final Resources r;
    private final Properties p;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionPanel(JFrame parent, Database db, CollectionManager cm, Resources r, Properties p) {
        this.parent = parent;
        this.db = db;
        this.cm = cm;
        this.r = r;
        this.p = p;
        this.feedback = new JLabel();
        this.listModel = new DefaultListModel();
        ResultSet rs = null;
        PreparedStatement st = null;
        String collectionId = db.escape(p.get("uploads.collectionId"));
        if (collectionId.equals("")) {
            collectionId = "-1";
        }
        try {
            String sql = " select c.path  from collection c  where c.id != ?  order by c.path asc ";
            st = db.prepare(" select c.path  from collection c  where c.id != ?  order by c.path asc ");
            st.setString(1, collectionId);
            rs = st.executeQuery();
            while (rs.next()) {
                this.listModel.addElement(rs.getString("path"));
            }
        }
        catch (SQLException e) {
            try {
                this.feedback.setText("Error loading collection information: " + e.getMessage());
            }
            catch (Throwable throwable) {
                Utils.close(rs);
                Utils.close(st);
                throw throwable;
            }
            Utils.close(rs);
            Utils.close(st);
        }
        Utils.close(rs);
        Utils.close(st);
        this.list = new JList(this.listModel);
        JPanel topPane = new JPanel();
        topPane.setLayout(new BorderLayout());
        topPane.add((Component)this.getButtonPane(), "North");
        topPane.add((Component)this.getInfoPane(), "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)topPane, "North");
        this.add((Component)new JScrollPane(this.list), "Center");
        this.add((Component)this.feedback, "South");
        cm.addCollectionManagerListener(this);
    }

    private JPanel getInfoPane() {
        JLabel infoLabel = new JLabel("<html><head></head><body>Here you can add the folders on your computer with your mp3's in.  Just click the 'Add' button above to get started.  You can also remove folders you've added by selecting them in the list and then clicking the 'Remove' button.</body></html>");
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p.add((Component)infoLabel, "Center");
        return p;
    }

    private void removeCollectionFolder() {
        String path;
        if (this.list.getSelectedIndex() != -1 && this.cm.removeDirectory(path = (String)this.list.getSelectedValue())) {
            this.listModel.remove(this.list.getSelectedIndex());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCollectionFolder() {
        PreparedStatement st;
        ResultSet rs;
        File newFolder;
        block5: {
            newFolder = null;
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            if (chooser.showOpenDialog(this.parent) != 0) {
                return;
            }
            newFolder = chooser.getSelectedFile();
            rs = null;
            st = null;
            try {
                String path = Utils.getPathWithSlash(newFolder);
                String sql = " select 1  from collection c  where substr(?,0,length(c.path)) = c.path ";
                st = this.db.prepare(" select 1  from collection c  where substr(?,0,length(c.path)) = c.path ");
                st.setString(1, path);
                rs = st.executeQuery();
                if (!rs.next()) break block5;
                JOptionPane.showMessageDialog(this.parent, "That folder is already in your collection!");
            }
            catch (SQLException e) {
                try {
                    this.feedback.setText(e.getMessage());
                }
                catch (Throwable throwable) {
                    Utils.close(rs);
                    Utils.close(st);
                    throw throwable;
                }
                Utils.close(rs);
                Utils.close(st);
                return;
            }
            Utils.close(rs);
            Utils.close(st);
            return;
        }
        Utils.close(rs);
        Utils.close(st);
        final File newFolderAgain = newFolder;
        new Thread(new Runnable(){

            public void run() {
                CollectionPanel.this.listModel.addElement(newFolderAgain.getAbsolutePath());
                CollectionPanel.this.cm.addDirectory(newFolderAgain);
            }
        }).start();
    }

    private JPanel getButtonPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.getFolderButtonPane(), "West");
        panel.add((Component)this.getMiscButtonPane(), "East");
        return panel;
    }

    private JPanel getMiscButtonPane() {
        Locale locale = this.r.getCurrentLocale();
        JButton rescan = new JButton(locale.getString("gui.label.rescanCollection"), new ImageIcon(this.r.getImage("icons/16x16/rescan.png")));
        rescan.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                new Thread(){

                    public void run() {
                        CollectionPanel.this.cm.checkCollection();
                    }
                }.start();
            }
        });
        JPanel panel = new JPanel(new FlowLayout(2));
        panel.add(rescan);
        return panel;
    }

    private JPanel getFolderButtonPane() {
        Locale locale = this.r.getCurrentLocale();
        JButton addFolder = new JButton(locale.getString("gui.label.addFolder"), new ImageIcon(this.r.getImage("icons/16x16/add.png")));
        addFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CollectionPanel.this.addCollectionFolder();
            }
        });
        JButton removeFolder = new JButton(locale.getString("gui.label.removeFolder"), new ImageIcon(this.r.getImage("icons/16x16/delete.png")));
        removeFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CollectionPanel.this.removeCollectionFolder();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(addFolder);
        panel.add(removeFolder);
        return panel;
    }

    public void collectionManagerChangePerformed(int type, String message) {
        switch (type) {
            case 7: {
                this.feedback.setText("Scanning: " + message);
                break;
            }
            case 1: {
                this.feedback.setText("Artist added: " + message);
                break;
            }
            case 2: {
                this.feedback.setText("Album added: " + message);
                break;
            }
            case 3: {
                this.feedback.setText("Track added: " + message);
                break;
            }
            case 6: {
                this.feedback.setText("Collection Updated!");
            }
        }
    }
}

