/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.commands;

import com.pugh.sockso.Utils;
import com.pugh.sockso.commands.BaseCommand;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.resources.Locale;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class UserActive
extends BaseCommand {
    private final Locale locale;
    private final Database db;

    public UserActive(Database db, Locale locale) {
        this.db = db;
        this.locale = locale;
    }

    public String getName() {
        return "useractive";
    }

    public String getDescription() {
        return "Toggles users between being active or not";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(String[] args) throws SQLException {
        String string;
        PreparedStatement st = null;
        try {
            String isActive = args[2].equals("1") ? "1" : "0";
            String sql = " update users  set is_active = ?  where id = ? ";
            st = this.db.prepare(" update users  set is_active = ?  where id = ? ");
            st.setString(1, isActive);
            st.setInt(2, Integer.parseInt(args[1]));
            int affectedRows = st.executeUpdate();
            string = affectedRows == 1 ? this.locale.getString("con.msg.userUpdated") : this.locale.getString("con.err.invalidUserId");
        }
        catch (Throwable throwable) {
            Utils.close(st);
            throw throwable;
        }
        Utils.close(st);
        return string;
    }

    public String[] getArguments() {
        return new String[]{"ID ISACTIVE (1/0)"};
    }
}

