/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.commands;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.commands.BaseCommand;
import com.pugh.sockso.resources.Locale;

public class PropSet
extends BaseCommand {
    private final Properties p;
    private final Locale locale;

    public PropSet(Properties p, Locale locale) {
        this.p = p;
        this.locale = locale;
    }

    public String getName() {
        return "propset";
    }

    public String getDescription() {
        return "Sets a property";
    }

    public String execute(String[] args) {
        String name = args[1];
        String value = Utils.joinArray(args, " ", 2, args.length - 1);
        this.p.set(name, value);
        this.p.save();
        return this.locale.getString("con.msg.propertySaved");
    }

    public int getNumArgs() {
        return 2;
    }

    public String[] getArguments() {
        return new String[]{"NAME", "VALUE"};
    }
}

