/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.weld.plugins.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.beans.metadata.plugins.AbstractDependencyMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.weld.plugins.dependency.UnsatisfiedDependencyRegistry;
import org.jboss.kernel.weld.plugins.dependency.WeldKernelControllerContext;

public class WeldDependencyMetaData
extends AbstractDependencyMetaData {
    private static final long serialVersionUID = 1L;
    private final InjectionPoint injectionPoint;
    private WeldKernelControllerContext context;
    private final ControllerState whenRequired;

    public WeldDependencyMetaData(InjectionPoint injectionPoint) {
        super((Object)injectionPoint);
        this.injectionPoint = injectionPoint;
        this.whenRequired = injectionPoint.getMember() instanceof Constructor ? ControllerState.INSTANTIATED : ControllerState.CONFIGURED;
    }

    public void initialVisit(MetaDataVisitor visitor) {
        KernelControllerContext context = visitor.getControllerContext();
        if (!(context instanceof WeldKernelControllerContext)) {
            throw new IllegalStateException("Context is not a WeldKernelControllerContext " + context.getName());
        }
        this.context = (WeldKernelControllerContext)context;
        visitor.addDependency((DependencyItem)new WeldDependencyItem(context.getName()));
    }

    protected int getHashCode() {
        int i = 17;
        i = 31 * i + this.injectionPoint.getMember().hashCode();
        for (Annotation ann : this.injectionPoint.getQualifiers()) {
            i = 31 * i + ((Object)ann).hashCode();
        }
        return i;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WeldDependencyMetaData)) {
            return false;
        }
        return WeldDependencyMetaData.equals((Object)this.injectionPoint.getMember(), (Object)((WeldDependencyMetaData)((Object)obj)).injectionPoint.getMember()) && WeldDependencyMetaData.equals((Object)this.injectionPoint.getQualifiers(), (Object)((WeldDependencyMetaData)((Object)obj)).injectionPoint.getQualifiers());
    }

    private class WeldDependencyItem
    extends AbstractDependencyItem {
        public WeldDependencyItem(Object name) {
            super(name, null, WeldDependencyMetaData.this.whenRequired, null);
        }

        public boolean resolve(Controller controller) {
            try {
                WeldDependencyMetaData.this.context.getManager().validate(WeldDependencyMetaData.this.injectionPoint);
                this.setIDependOn(WeldDependencyMetaData.this.injectionPoint);
                this.setResolved(true);
            }
            catch (InjectionException e) {
                UnsatisfiedDependencyRegistry.getInstance().addHungContext(WeldDependencyMetaData.this.context);
                this.setResolved(false);
            }
            return this.isResolved();
        }

        public void unresolved() {
            this.setIDependOn(null);
            this.setResolved(false);
        }
    }
}

