/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.metadata;

import org.jboss.dependency.spi.ControllerContext;
import org.jboss.deployers.plugins.metadata.AbstractFromDeploymentDelegate;
import org.jboss.deployers.plugins.metadata.FromDeploymentDelegate;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FromDeployment {
    DEPLOYMENT(new DefaultFromDeploymentDelegate()),
    SIMPLE_NAME(new SimpleNameFromDeploymentDelegate()),
    TOP_DEPLOYMENT(new TopDeploymentDelegate()),
    TOP_SIMPLE_NAME(new TopSimpleNameDeploymentDelegate());

    private FromDeploymentDelegate delegate;

    private FromDeployment(FromDeploymentDelegate delegate) {
        this.delegate = delegate;
    }

    public Object executeLookup(ControllerContext context) {
        return this.delegate.executeLookup(context);
    }

    public static FromDeployment getInstance(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        for (FromDeployment fd : FromDeployment.values()) {
            if (!type.equalsIgnoreCase(fd.name())) continue;
            return fd;
        }
        throw new IllegalArgumentException("NO such FromDeployment: " + type);
    }

    private static class TopSimpleNameDeploymentDelegate
    extends AbstractFromDeploymentDelegate {
        private TopSimpleNameDeploymentDelegate() {
        }

        public Object executeLookup(ControllerContext context) {
            DeploymentUnit unit = this.getDeploymentUnit(context);
            return unit != null ? unit.getTopLevel().getSimpleName() : null;
        }
    }

    private static class TopDeploymentDelegate
    extends AbstractFromDeploymentDelegate {
        private TopDeploymentDelegate() {
        }

        public Object executeLookup(ControllerContext context) {
            DeploymentUnit unit = this.getDeploymentUnit(context);
            return unit != null ? unit.getTopLevel() : null;
        }
    }

    private static class SimpleNameFromDeploymentDelegate
    extends AbstractFromDeploymentDelegate {
        private SimpleNameFromDeploymentDelegate() {
        }

        public Object executeLookup(ControllerContext context) {
            DeploymentUnit unit = this.getDeploymentUnit(context);
            return unit != null ? unit.getSimpleName() : null;
        }
    }

    private static class DefaultFromDeploymentDelegate
    extends AbstractFromDeploymentDelegate {
        private DefaultFromDeploymentDelegate() {
        }

        public Object executeLookup(ControllerContext context) {
            return this.getDeploymentUnit(context);
        }
    }
}

